/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.Ornament;
import com.adobe.acrobat.gui.OrnamentList;
import com.adobe.acrobat.gui.OrnamentSizingStrategy;
import com.adobe.acrobat.gui.PageOrnamentFactory;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.VOrnamentList;
import com.adobe.acrobat.gui.VPDFPagePainting;
import com.adobe.acrobat.page.ContentArray;
import com.adobe.acrobat.page.VPageContentArray;
import com.adobe.acrobat.pdf.VPageProps;
import com.adobe.acrobat.pdf.VPageRefByNum;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.VPDFReference;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.vtypes.VAffineTransform;
import com.adobe.acrobat.vtypes.VFloatPoint;
import com.adobe.acrobat.vtypes.VFloatRect;
import com.adobe.pe.awt.VRectangle;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.painting.VPainting;
import com.adobe.pe.vtypes.VInt;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Dictionary;
import java.util.Enumeration;

public class VisiblePage {
    public VPDFReference vPageRef;
    public int pageNum;
    public PageView pv;
    VAffineTransform vGalleyTransform = new VTransformForPage(true);
    VAffineTransform vPageTransform = new VTransformForPage(false);
    VRectangle vPageCellRectangle = new VPageCellRectangle();
    VRectangle vPageRectangle = new VPageRectangle();
    private VInt vPageRow = new VPageRowOrColumn(true);
    private VInt vPageColumn = new VPageRowOrColumn(false);
    VFloatPoint vPageOrigin = new VPageOrigin();
    VFloatRect vAperturePageSpace = new VAperturePageSpace();
    VFloatRect vContentBoundingBox = new VContentBoundingBox();
    VPainting vPagePainting;
    VOrnamentList vPageOrnaments = new VPageOrnamentList();
    private VFloatRect vPageOrnamentBoundingBox = new VPageOrnamentBoundingBox();

    VisiblePage(PageView pageView, int n) {
        this.pv = pageView;
        this.pageNum = n;
        this.vPageRef = VPageRefByNum.getVPageRefByNum(pageView.getAcroViewContext().getVPDFObjStore(), n);
        this.vPagePainting = new VPDFPagePainting(this);
    }

    public Dictionary createActionParamsDictionary(Requester requester) throws Exception {
        Dictionary dictionary = this.pv.createActionParamsDictionary(requester);
        dictionary.put("VisiblePage", this);
        return dictionary;
    }

    public int getColumn(Requester requester) throws Exception {
        return this.vPageColumn.intValue(requester);
    }

    public PDFReference getPageRef(Requester requester) throws Exception {
        return this.vPageRef.pdfReferenceValue(requester);
    }

    public int getRow(Requester requester) throws Exception {
        return this.vPageRow.intValue(requester);
    }

    public void pageIsInvisible(Requester requester) throws Exception {
        OrnamentList ornamentList = this.vPageOrnaments.ornamentListValue(requester);
        Enumeration enumeration = ornamentList.getOrnaments();
        while (enumeration.hasMoreElements()) {
            Ornament ornament = (Ornament)enumeration.nextElement();
            ornament.isInvisible(requester);
        }
    }

    class VTransformForPage
    extends VAffineTransform {
        private boolean inGalleySpace;

        VTransformForPage(boolean bl) {
            this.inGalleySpace = bl;
        }

        protected final AffineTransform computeAffineTransform(Requester requester) throws Exception {
            PDFReference pDFReference = VisiblePage.this.vPageRef.pdfReferenceValue(requester);
            if (this.inGalleySpace) {
                Rectangle rectangle = VisiblePage.this.vPageRectangle.rectangleValue(requester);
                if (rectangle == null) {
                    return null;
                }
                AffineTransform affineTransform = VisiblePage.this.vPageTransform.affineTransformValue(requester);
                affineTransform = affineTransform.translate(rectangle.x, rectangle.y);
                return affineTransform;
            }
            AffineTransform affineTransform = VPageProps.getDefaultTransform(pDFReference).affineTransformValue(requester);
            float f = VisiblePage.this.pv.getScale(requester);
            return affineTransform.scale(f);
        }
    }

    class VPageCellRectangle
    extends VRectangle {
        VPageCellRectangle() {
        }

        protected final Rectangle computeRectangle(Requester requester) throws Exception {
            int n = VisiblePage.this.pv.getPageColumn(VisiblePage.this.pageNum, requester);
            int n2 = VisiblePage.this.pv.getPageRow(VisiblePage.this.pageNum, requester);
            if (n == -1 || n2 == -1) {
                return null;
            }
            int n3 = VisiblePage.this.pv.getNthColumnStart(n, requester);
            int n4 = VisiblePage.this.pv.getNthRowStart(n2, requester);
            int n5 = VisiblePage.this.pv.getNthColumnWidthDeviceSpace(n, requester);
            int n6 = VisiblePage.this.pv.getNthRowHeightDeviceSpace(n2, requester);
            return new Rectangle(n3, n4, n5, n6);
        }
    }

    class VPageRectangle
    extends VRectangle {
        VPageRectangle() {
        }

        protected final Rectangle computeRectangle(Requester requester) throws Exception {
            int n;
            int n2;
            FloatRect floatRect = VPageProps.getCropBox(VisiblePage.this.vPageRef).floatRectValue(requester);
            AffineTransform affineTransform = VisiblePage.this.vPageTransform.affineTransformValue(requester);
            if (affineTransform == null) {
                return null;
            }
            Rectangle rectangle = VisiblePage.this.vPageCellRectangle.rectangleValue(requester);
            if (rectangle == null) {
                return null;
            }
            FloatRect floatRect2 = floatRect.transformRect(affineTransform);
            Rectangle rectangle2 = floatRect2.toEnclosingRect();
            int n3 = VisiblePage.this.pv.getNumRows(requester);
            rectangle2.y = n3 == 1 ? rectangle.y + (rectangle.height - rectangle2.height) / 2 : ((n2 = VisiblePage.this.getRow(requester)) == 0 ? rectangle.y + rectangle.height - rectangle2.height - 1 - 2 - 3 : rectangle.y + 1 + 3);
            n2 = VisiblePage.this.pv.getNumColumns(requester);
            rectangle2.x = n2 == 1 ? rectangle.x + (rectangle.width - rectangle2.width) / 2 : ((n = VisiblePage.this.getColumn(requester)) == 0 ? rectangle.x + rectangle.width - rectangle2.width - 1 - 2 - 3 : rectangle.x + 1 + 3);
            return rectangle2;
        }
    }

    class VPageRowOrColumn
    extends VInt {
        private boolean forRow;

        VPageRowOrColumn(boolean bl) {
            this.forRow = bl;
        }

        protected final int computeInt(Requester requester) throws Exception {
            int n = VisiblePage.this.pv.getTopLeftPage(requester);
            int n2 = VisiblePage.this.pv.getNumColumns(requester);
            int n3 = VisiblePage.this.pv.getNumRows(requester);
            int n4 = (VisiblePage.this.pageNum - n) / n2;
            if (n4 < 0 || n4 >= n3) {
                return -1;
            }
            if (this.forRow) {
                return n4;
            }
            return (VisiblePage.this.pageNum - n) % n2;
        }
    }

    class VPageOrigin
    extends VFloatPoint {
        VPageOrigin() {
        }

        protected final FloatPoint computeFloatPoint(Requester requester) throws Exception {
            Point point = VisiblePage.this.pv.getScrollPosition(requester);
            AffineTransform affineTransform = VisiblePage.this.vGalleyTransform.affineTransformValue(requester);
            if (affineTransform == null) {
                return null;
            }
            affineTransform = affineTransform.getInverse();
            FloatPoint floatPoint = new FloatPoint(point.x, point.y);
            affineTransform.transformPoint(floatPoint, floatPoint);
            return floatPoint;
        }
    }

    class VAperturePageSpace
    extends VFloatRect {
        VAperturePageSpace() {
        }

        protected final FloatRect computeFloatRect(Requester requester) throws Exception {
            Point point = VisiblePage.this.pv.getScrollPosition(requester);
            Dimension dimension = VisiblePage.this.pv.getApertureSize(requester);
            Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
            AffineTransform affineTransform = VisiblePage.this.vGalleyTransform.affineTransformValue(requester);
            affineTransform = affineTransform.getInverse();
            FloatRect floatRect = new FloatRect(rectangle).transformRect(affineTransform);
            return floatRect;
        }
    }

    class VContentBoundingBox
    extends VFloatRect {
        VContentBoundingBox() {
        }

        protected final FloatRect computeFloatRect(Requester requester) throws Exception {
            PDFReference pDFReference = VisiblePage.this.vPageRef.pdfReferenceValue(requester);
            ContentArray contentArray = VPageContentArray.getVPageContentArray(pDFReference).contentArrayValue(requester);
            FloatRect floatRect = contentArray.getBoundingBox();
            FloatRect floatRect2 = VisiblePage.this.vPageOrnamentBoundingBox.floatRectValue(requester);
            if (floatRect2 != null) {
                floatRect = floatRect == null ? floatRect2 : floatRect.union(floatRect2);
            }
            FloatRect floatRect3 = VPageProps.getCropBox(pDFReference).floatRectValue(requester);
            return floatRect == null ? floatRect3 : floatRect.intersect(floatRect3);
        }
    }

    class VPageOrnamentList
    extends VOrnamentList {
        VPageOrnamentList() {
        }

        protected final OrnamentList computeOrnamentList(Requester requester) throws Exception {
            OrnamentList ornamentList = new OrnamentList();
            PageOrnamentFactory.invokeFactories(ornamentList, VisiblePage.this, requester);
            return ornamentList;
        }
    }

    class VPageOrnamentBoundingBox
    extends VFloatRect {
        VPageOrnamentBoundingBox() {
        }

        protected final FloatRect computeFloatRect(Requester requester) throws Exception {
            OrnamentList ornamentList = VisiblePage.this.vPageOrnaments.ornamentListValue(requester);
            FloatRect floatRect = null;
            Enumeration enumeration = ornamentList.getOrnaments();
            while (enumeration.hasMoreElements()) {
                OrnamentSizingStrategy ornamentSizingStrategy;
                Ornament ornament = (Ornament)enumeration.nextElement();
                if (!(ornament instanceof OrnamentSizingStrategy) || !(ornamentSizingStrategy = (OrnamentSizingStrategy)((Object)ornament)).partOfContents(requester) || !ornamentSizingStrategy.sizeInUserSpace(requester)) continue;
                FloatPoint floatPoint = ornamentSizingStrategy.getOrnamentSize(requester);
                FloatPoint floatPoint2 = ornamentSizingStrategy.getOrnamentPosition(requester);
                FloatRect floatRect2 = new FloatRect(floatPoint2, new FloatPoint(floatPoint2.x + floatPoint.x, floatPoint2.y + floatPoint.y));
                FloatRect floatRect3 = floatRect = floatRect == null ? floatRect2 : floatRect.union(floatRect2);
            }
            return floatRect;
        }
    }
}

