/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.SimpleUIVerb;
import com.adobe.pe.awt.UIVerb;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.vtypes.VBoolean;

class TocUIVerb
extends UIVerb {
    AcroViewContext context;
    int selector;

    TocUIVerb(int n, AcroViewContext acroViewContext) {
        this.context = acroViewContext;
        this.selector = n;
        VBoolean vBoolean = SimpleUIVerb.getVDocIsOpenBoolean(acroViewContext);
        VBookmarkIsSelectedBoolean vBookmarkIsSelectedBoolean = new VBookmarkIsSelectedBoolean();
        TocTransactor tocTransactor = new TocTransactor();
        this.setAttributes(tocTransactor, vBoolean, vBookmarkIsSelectedBoolean);
    }

    public static void registerCommands(AcroViewContext acroViewContext) {
        CommandRegistry.addCommand(new TocUIVerb(15, acroViewContext), acroViewContext, "ToggleBookmarks");
        CommandRegistry.addCommand(new TocUIVerb(13, acroViewContext), acroViewContext, "HideBookmarks");
        CommandRegistry.addCommand(new TocUIVerb(14, acroViewContext), acroViewContext, "ShowBookmarks");
    }

    class TocTransactor
    extends Transactor {
        TocTransactor() {
        }

        public void buildChanges(Transaction transaction) throws Exception {
            int n = TocUIVerb.this.selector;
            if (TocUIVerb.this.marked(transaction)) {
                if (n == 15 || n == 13) {
                    TocUIVerb.this.context.hideTOC(transaction);
                }
            } else if (n == 15 || n == 14) {
                TocUIVerb.this.context.showTOC(transaction);
            }
        }
    }

    class VBookmarkIsSelectedBoolean
    extends VBoolean {
        VBookmarkIsSelectedBoolean() {
        }

        protected final boolean computeBoolean(Requester requester) throws Exception {
            if (SimpleUIVerb.getVDocIsOpenBoolean(TocUIVerb.this.context).booleanValue(requester)) {
                return TocUIVerb.this.context.getTocDimension().dimensionValue((Requester)requester).width != 0;
            }
            return false;
        }
    }
}

