/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.TextSelection;
import com.adobe.acrobat.gui.TextSelectionMTC;
import com.adobe.acrobat.gui.Tool;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.MouseTransactionClient;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class TextSelectionTool
extends Tool {
    private static final String TextSelection_K = "TextSelection";
    private static Tool gTextSelectionTool = null;

    private TextSelectionTool() {
        super(Util.getMenuVString("SelectText"), "textsel.gif");
    }

    public boolean canSelectAll(PageView pageView, Requester requester) throws Exception {
        PDFObjStore pDFObjStore = pageView.getPDFObjStore(requester);
        return pDFObjStore != null;
    }

    public Cursor getCursor(PageView pageView, Requester requester) throws Exception {
        return Cursor.getPredefinedCursor(2);
    }

    public String getStatusString(PageView pageView, Requester requester) throws Exception {
        return Util.getAcroViewContextString("TextSelectionTool:SelectTextStatusString");
    }

    public static synchronized Tool getTextSelectionTool() {
        if (gTextSelectionTool == null) {
            gTextSelectionTool = new TextSelectionTool();
        }
        return gTextSelectionTool;
    }

    static void register() {
        Tool.registerTool(TextSelection_K, TextSelectionTool.getTextSelectionTool());
    }

    public void selectAll(PageView pageView, Transaction transaction) throws Exception {
        TextSelection textSelection = TextSelection.getEmptyTextSelection();
        if (pageView.getPageLayout(transaction).equals("SinglePage")) {
            textSelection = new TextSelection(pageView, pageView.getCurrentPageRef(transaction), 0, Integer.MAX_VALUE);
        } else {
            int n;
            int n2 = n = pageView.getNumPages(transaction);
            while (n2-- > 0) {
                textSelection = textSelection.addToSelection(pageView, pageView.getPageRef(n2, transaction), 0, Integer.MAX_VALUE, transaction);
            }
        }
        pageView.setSelection(transaction, textSelection);
    }

    public MouseTransactionClient wantsMouseTransactionControl(Transaction transaction, PageView pageView, MouseEvent mouseEvent) throws Exception {
        return new TextSelectionMTC(pageView);
    }
}

