/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.GroupBox;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.LightWeightPanel;
import com.adobe.pe.awt.MultilineLabel;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ProxyPanel
extends Panel
implements ItemListener {
    private TextField nonProxy;
    private TextField http;
    private TextField httpPort;
    private TextField ftp;
    private TextField ftpPort;
    private Container proxy;
    private Container except;
    private Container warn;
    private Container main;
    private GridBagLayout gProxy;
    private GridBagLayout gExcept;
    private GridBagLayout gWarn;
    private GridBagLayout gMain;
    private GridBagConstraints cProxy;
    private GridBagConstraints cExcept;
    private GridBagConstraints cWarn;
    private GridBagConstraints cMain;
    private Checkbox sameProxy;

    public ProxyPanel() {
        this.setLayout(new FlowLayout());
        this.setBackground(SystemColor.menu);
        this.createGridPanels();
        this.createWarningElements();
        this.createProxyElements();
        this.createExceptElements();
        this.addRowFill(this.main, this.gMain, this.cMain, this.proxy, 1);
        this.addRowFill(this.main, this.gMain, this.cMain, this.except, 5);
        this.addRowFill(this.main, this.gMain, this.cMain, this.warn, 5);
        this.add(this.main);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component) {
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void addRow(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string, Component component) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        Label label = new Label(string, 2);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        container.add(label);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void addRowFill(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component, int n) {
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n, 4, 1, 4);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void createExceptElements() {
        Label label = new Label(Util.getDialogString("Proxy:ExceptTop"));
        this.nonProxy = new TextField(50);
        MultilineLabel multilineLabel = new MultilineLabel(Util.getDialogString("Proxy:ExceptBottom"), -1);
        this.addRow(this.except, this.gExcept, this.cExcept, label);
        this.addRow(this.except, this.gExcept, this.cExcept, this.nonProxy);
        this.addRow(this.except, this.gExcept, this.cExcept, multilineLabel);
    }

    private void createGridPanels() {
        this.warn = new LightWeightPanel();
        this.gWarn = new GridBagLayout();
        this.cWarn = new GridBagConstraints();
        this.warn.setLayout(this.gWarn);
        this.cWarn.insets = new Insets(1, 4, 1, 4);
        this.cWarn.fill = 1;
        this.proxy = new GroupBox(Util.getDialogString("Proxy:Server"));
        this.gProxy = new GridBagLayout();
        this.cProxy = new GridBagConstraints();
        this.proxy.setLayout(this.gProxy);
        this.cProxy.insets = new Insets(1, 4, 1, 4);
        this.cProxy.fill = 1;
        this.except = new GroupBox(Util.getDialogString("Proxy:Except"));
        this.gExcept = new GridBagLayout();
        this.cExcept = new GridBagConstraints();
        this.except.setLayout(this.gExcept);
        this.cExcept.insets = new Insets(1, 4, 1, 4);
        this.cExcept.fill = 1;
        this.main = new LightWeightPanel();
        this.gMain = new GridBagLayout();
        this.cMain = new GridBagConstraints();
        this.main.setLayout(this.gMain);
        this.cMain.fill = 1;
    }

    private void createProxyElements() {
        this.http = new TextField(30);
        this.httpPort = new TextField(5);
        LightWeightPanel lightWeightPanel = new LightWeightPanel(new FlowLayout());
        lightWeightPanel.add(this.http);
        lightWeightPanel.add(new Label(Util.getDialogString("Proxy:PORT")));
        lightWeightPanel.add(this.httpPort);
        this.addRow(this.proxy, this.gProxy, this.cProxy, Util.getDialogString("Proxy:HTTP"), lightWeightPanel);
        this.ftp = new TextField(30);
        this.ftpPort = new TextField(5);
        LightWeightPanel lightWeightPanel2 = new LightWeightPanel(new FlowLayout());
        lightWeightPanel2.add(this.ftp);
        lightWeightPanel2.add(new Label(Util.getDialogString("Proxy:PORT")));
        lightWeightPanel2.add(this.ftpPort);
        this.addRow(this.proxy, this.gProxy, this.cProxy, Util.getDialogString("Proxy:FTP"), lightWeightPanel2);
        this.sameProxy = new Checkbox(Util.getDialogString("Proxy:SameServer"));
        this.addRow(this.proxy, this.gProxy, this.cProxy, this.sameProxy);
        this.sameProxy.addItemListener(this);
    }

    private void createWarningElements() {
        MultilineLabel multilineLabel = new MultilineLabel(Util.getDialogString("Proxy:Warn"), -1);
        this.warn.setBackground(this.getBackground().brighter());
        this.addRow(this.warn, this.gWarn, this.cWarn, multilineLabel);
    }

    void init() {
        this.ftp.setText(ReaderPrefs.fFtpProxyHost);
        this.ftpPort.setText(ReaderPrefs.fFtpProxyPort);
        this.sameProxy.setState(ReaderPrefs.fFtpProxySet ^ true);
        this.nonProxy.setText(ReaderPrefs.fHttpNonProxyHosts);
        this.http.setText(ReaderPrefs.fHttpProxyHost);
        this.httpPort.setText(ReaderPrefs.fHttpProxyPort);
        this.setEnabledNonHTTP(this.sameProxy.getState() ^ true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.sameProxy) {
            this.setEnabledNonHTTP(this.sameProxy.getState() ^ true);
        }
    }

    public void save() {
        ReaderPrefs.fFtpProxyHost = this.ftp.getText().trim();
        ReaderPrefs.fFtpProxyPort = this.ftpPort.getText().trim();
        ReaderPrefs.fFtpProxySet = this.sameProxy.getState() ^ true;
        ReaderPrefs.fHttpNonProxyHosts = this.nonProxy.getText().trim();
        ReaderPrefs.fHttpProxyHost = this.http.getText().trim();
        ReaderPrefs.fHttpProxyPort = this.httpPort.getText().trim();
        ReaderPrefs.writeProxySettings();
    }

    private void setEnabledNonHTTP(boolean bl) {
        this.ftp.setEnabled(bl);
        this.ftpPort.setEnabled(bl);
    }
}

