/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.ComboButton;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.pdf.VPageProps;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.WriteLockException;
import java.awt.CheckboxMenuItem;
import java.awt.ItemSelectable;
import java.awt.PopupMenu;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class PageLayoutButton
extends ComboButton
implements VObserver,
ItemListener,
StrobeContainer {
    AcroViewContext context;
    private PageView pv;
    private boolean fAddedPopup = false;
    private PopupMenu popup;
    private CheckboxMenuItem fSinglePage;
    private CheckboxMenuItem fContinuous;
    private CheckboxMenuItem fFacingPages;
    private VStrobe strobe;
    private static final String OneColumn_K = "OneColumn";
    private static final String TwoColumn_K = "TwoColumn";
    private static final String TwoColumnLeft_K = "TwoColumnLeft";
    private static final String TwoColumnRight_K = "TwoColumnRight";
    private static final String SinglePage_K = "SinglePage";

    public PageLayoutButton(AcroViewContext acroViewContext) {
        super("", "pagesize.gif", false);
        this.context = acroViewContext;
        this.pv = acroViewContext.getPageView();
        this.popup = new PopupMenu();
        this.fSinglePage = new CheckboxMenuItem(Util.getDialogString("PageView:SinglePage"), true);
        this.fSinglePage.addItemListener(this);
        this.popup.add(this.fSinglePage);
        this.fContinuous = new CheckboxMenuItem(Util.getDialogString("PageView:Continuous"), false);
        this.fContinuous.addItemListener(this);
        this.popup.add(this.fContinuous);
        this.fFacingPages = new CheckboxMenuItem(Util.getDialogString("PageView:FacingPages"), false);
        this.fFacingPages.addItemListener(this);
        this.popup.add(this.fFacingPages);
        this.add(this.popup);
        this.strobe = new VStrobe(this);
    }

    public void change(Requester requester) throws WriteLockException {
        try {
            PDFReference pDFReference = this.context.getPageView().getCurrentPageRef(requester);
            if (pDFReference == null) {
                this.setString("");
                return;
            }
            FloatRect floatRect = VPageProps.getCropBox(pDFReference).floatRectValue(requester);
            double d = floatRect.width();
            double d2 = floatRect.height();
            String string = ReaderPrefs.fPageUnitsStr.stringValue(requester);
            String string2 = Util.getDialogString("Units:" + string + ":Abbr");
            double d3 = string.equals("Millimeters") ? 0.35277777777777775 : (string.equals("Points") ? 1.0 : 0.013888888888888888);
            this.setString(Util.getAcroViewContextString("PageLayoutButton:PageSizeString", new Double(d *= d3), new Double(d2 *= d3), string2));
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (Exception exception) {
            this.setString("");
        }
        this.repaint();
    }

    public boolean isEnabled() {
        boolean bl = false;
        try {
            bl = super.isEnabled() && this.pv.getNumPages(null) > 1;
        }
        catch (Exception exception) {}
        return bl;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        block8: {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            int n = itemEvent.getStateChange();
            if (n != 1) break block8;
            String string = null;
            if (itemSelectable == this.fSinglePage) {
                string = SinglePage_K;
            } else if (itemSelectable == this.fContinuous) {
                string = OneColumn_K;
            } else if (itemSelectable == this.fFacingPages) {
                string = TwoColumnRight_K;
            }
            if (string == null) {
                return;
            }
            final String string2 = string;
            Transactor transactor = new Transactor(){

                public void buildChanges(Transaction transaction) throws Exception {
                    context.getPageView().setPageLayout(transaction, string2);
                }
            };
            try {
                transactor.commit(this.context);
            }
            catch (Exception exception) {
                Log.clog("PageLayoutButton.action: " + exception.toString());
            }
        }
    }

    public void performComboButtonAction() {
        this.fSinglePage.setState(false);
        this.fContinuous.setState(false);
        this.fFacingPages.setState(false);
        try {
            String string = this.context.getPageView().getPageLayout(null);
            if (string.equals(OneColumn_K)) {
                this.fContinuous.setState(true);
            } else if (string.equals(TwoColumn_K) || string.equals(TwoColumnLeft_K) || string.equals(TwoColumnRight_K)) {
                this.fFacingPages.setState(true);
            } else {
                this.fSinglePage.setState(true);
            }
        }
        catch (Exception exception) {
            Log.clog("PageLayoutButton.action: " + exception.toString());
            return;
        }
        this.popup.show(this, 0, 0);
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }
}

