/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.GoToPageDialog;
import com.adobe.acrobat.gui.PVNavigation;
import com.adobe.acrobat.gui.PageView;
import com.adobe.pe.awt.UIVerb;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.TransactionExecutionContext;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.vtypes.VBoolean;

class PVNavigationVerb
extends UIVerb {
    private PageView pv;
    private String selector;

    PVNavigationVerb(PageView pageView, String string) {
        this.pv = pageView;
        this.selector = string;
        VPVNavEnabledBoolean vPVNavEnabledBoolean = new VPVNavEnabledBoolean();
        PVNavTransactor pVNavTransactor = new PVNavTransactor();
        this.setAttributes(pVNavTransactor, vPVNavEnabledBoolean, null);
    }

    public void invoke(TransactionExecutionContext transactionExecutionContext) throws Exception {
        AcroViewContext acroViewContext = (AcroViewContext)transactionExecutionContext;
        acroViewContext.getVNavigationSynchronizer().setTransactor(transactionExecutionContext, this.getTransactor());
    }

    class VPVNavEnabledBoolean
    extends VBoolean {
        VPVNavEnabledBoolean() {
        }

        protected final boolean computeBoolean(Requester requester) throws Exception {
            if (PVNavigationVerb.this.pv.getNumPages(requester) > 1) {
                if (PVNavigationVerb.this.selector.equals("PageUp") || PVNavigationVerb.this.selector.equals("LineUp")) {
                    return PVNavigation.pageScrollEnabled(PVNavigationVerb.this.pv, true, requester);
                }
                if (PVNavigationVerb.this.selector.equals("PageDown") || PVNavigationVerb.this.selector.equals("LineDown")) {
                    return PVNavigation.pageScrollEnabled(PVNavigationVerb.this.pv, false, requester);
                }
                if (PVNavigationVerb.this.selector.equals("FirstPage")) {
                    return PVNavigationVerb.this.pv.getCurrentPage(requester) != 0;
                }
                if (PVNavigationVerb.this.selector.equals("LastPage")) {
                    return PVNavigationVerb.this.pv.getCurrentPage(requester) != PVNavigationVerb.this.pv.getNumPages(requester) - 1;
                }
                if (PVNavigationVerb.this.selector.equals("PrevPage")) {
                    return PVNavigationVerb.this.pv.getCurrentPage(requester) > 0;
                }
                if (PVNavigationVerb.this.selector.equals("NextPage")) {
                    return PVNavigationVerb.this.pv.getCurrentPage(requester) < PVNavigationVerb.this.pv.getNumPages(requester) - 1;
                }
                if (PVNavigationVerb.this.selector.equals("GoToPage")) {
                    return PVNavigationVerb.this.pv.getNumPages(requester) > 1;
                }
            }
            return false;
        }
    }

    class PVNavTransactor
    extends Transactor {
        PVNavTransactor() {
        }

        public void buildChanges(Transaction transaction) throws Exception {
            if (PVNavigationVerb.this.selector.equals("PageUp")) {
                PVNavigation.pageScroll(transaction, PVNavigationVerb.this.pv, true, false);
            } else if (PVNavigationVerb.this.selector.equals("PageDown")) {
                PVNavigation.pageScroll(transaction, PVNavigationVerb.this.pv, false, false);
            } else if (PVNavigationVerb.this.selector.equals("LineUp")) {
                PVNavigation.pageScroll(transaction, PVNavigationVerb.this.pv, true, true);
            } else if (PVNavigationVerb.this.selector.equals("LineDown")) {
                PVNavigation.pageScroll(transaction, PVNavigationVerb.this.pv, false, true);
            } else if (PVNavigationVerb.this.selector.equals("FirstPage")) {
                PVNavigationVerb.this.pv.goToPage(transaction, 0);
            } else if (PVNavigationVerb.this.selector.equals("LastPage")) {
                PVNavigationVerb.this.pv.goToPage(transaction, PVNavigationVerb.this.pv.getNumPages(transaction) - 1);
            } else if (PVNavigationVerb.this.selector.equals("PrevPage")) {
                PVNavigationVerb.this.pv.goToPage(transaction, PVNavigationVerb.this.pv.getCurrentPage(transaction) - 1);
            } else if (PVNavigationVerb.this.selector.equals("NextPage")) {
                PVNavigationVerb.this.pv.goToPage(transaction, PVNavigationVerb.this.pv.getCurrentPage(transaction) + 1);
            } else if (PVNavigationVerb.this.selector.equals("GoToPage")) {
                new GoToPageDialog(PVNavigationVerb.this.pv.getAcroViewContext());
            }
        }
    }
}

