/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.CacheDisplayButton;
import com.adobe.acrobat.gui.PageButton;
import com.adobe.acrobat.gui.PageLayoutButton;
import com.adobe.acrobat.gui.ZoomLevelButton;
import com.adobe.acrobat.util.FontCache;
import com.adobe.pe.awt.LightWeightPanel;
import com.adobe.pe.awt.VLabel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.Toolkit;

public class NavigationBar
extends LightWeightPanel {
    private static final int kLabelAdj = 0;
    private CardLayout cards = new CardLayout();

    public NavigationBar(AcroViewContext acroViewContext) {
        this.setLayout(this.cards);
        Bar bar = new Bar(acroViewContext);
        FontStatus fontStatus = new FontStatus();
        this.add("Bar", bar);
        this.add("Status", fontStatus);
        this.cards.show(this, "Bar");
    }

    public class Bar
    extends LightWeightPanel
    implements LayoutManager {
        public Bar(AcroViewContext acroViewContext) {
            this.setLayout(this);
            this.setFont(new Font("sansserif", 0, 12));
            this.setCursor(Cursor.getDefaultCursor());
            this.setBackground(SystemColor.menu);
            PageButton pageButton = new PageButton(acroViewContext);
            ZoomLevelButton zoomLevelButton = new ZoomLevelButton(acroViewContext);
            PageLayoutButton pageLayoutButton = new PageLayoutButton(acroViewContext);
            CacheDisplayButton cacheDisplayButton = new CacheDisplayButton(acroViewContext);
            VLabel vLabel = new VLabel(acroViewContext.getStatusVString());
            this.add(pageButton);
            this.add(zoomLevelButton);
            this.add(pageLayoutButton);
            this.add(cacheDisplayButton);
            this.add(vLabel);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            int n = this.getSize().height;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.getComponentCount()) {
                Component component = container.getComponent(n3);
                if (component.isVisible()) {
                    Dimension dimension = component.getPreferredSize();
                    if (component instanceof Label) {
                        n2 += 0;
                    }
                    component.setBounds(n2, 0, n3 == this.getComponentCount() - 1 ? this.getSize().width - n2 : dimension.width, n);
                    n2 += dimension.width;
                    if (component instanceof Label) {
                        n2 += 0;
                    }
                }
                ++n3;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < container.getComponentCount()) {
                Component component = container.getComponent(n3);
                Dimension dimension = component.getMinimumSize();
                n = Math.max(dimension.height, n);
                n2 += dimension.width;
                ++n3;
            }
            return new Dimension(n2, n);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < container.getComponentCount()) {
                Component component = this.getComponent(n3);
                Dimension dimension = component.getPreferredSize();
                n = Math.max(dimension.height, n);
                n2 += dimension.width;
                ++n3;
            }
            return new Dimension(n2, n);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    public class FontStatus
    extends LightWeightPanel
    implements FontCache.FontCacheListener {
        private Font font;
        private Dimension dim;
        private String tip;
        private int y;

        public FontStatus() {
            this.setBackground(SystemColor.info);
            FontCache.getTheFontCache().addFontCacheListener(this);
            this.dim = new Dimension(200, 12);
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.dim;
        }

        public void paint(Graphics graphics) {
            graphics.setColor(SystemColor.info);
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            graphics.setFont(this.font);
            graphics.setColor(SystemColor.infoText);
            if (this.tip != null) {
                graphics.drawString(this.tip, 2, this.y);
            }
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }

        public void setText(String string) {
            this.tip = string;
            this.font = new Font("Arial", 0, 12);
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            this.y = fontMetrics.getHeight();
            this.repaint();
        }

        public void statusUpdate(FontCache.FontCacheEvent fontCacheEvent) {
            NavigationBar.this.cards.show(NavigationBar.this, "Status");
            this.setText(fontCacheEvent.getText());
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void updateEnded(FontCache.FontCacheEvent fontCacheEvent) {
            NavigationBar.this.cards.show(NavigationBar.this, "Bar");
        }
    }
}

