/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.BasicDialog;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Session;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.MessageDialog;
import com.adobe.pe.util.PEUtil;
import com.adobe.util.MemUtil;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class IronCityPrint {
    private boolean canceled = false;
    private Frame parent;
    private AcroViewContext context;
    private String lastServer = null;
    private String lastPrinter = null;
    private String getPrinterScript = null;
    private String printPrinterScript = null;
    private boolean shrinkToFit;

    public IronCityPrint(AcroViewContext acroViewContext, Properties properties, int n, int n2, int n3) {
        this.context = acroViewContext;
        this.parent = PEUtil.getFrame(PEUtil.getFrame(acroViewContext.getRootComponent()));
        this.lastServer = ReaderPrefs.fPrintServerPath;
        this.lastPrinter = ReaderPrefs.fLastPrinter;
        this.shrinkToFit = ReaderPrefs.fShrinkToFit;
        this.getPrinterScript = ReaderPrefs.fPrintServerGetPrinters;
        this.printPrinterScript = ReaderPrefs.fPrintServerPrint;
        PrinterDialog printerDialog = new PrinterDialog(this.parent, this.lastServer, this.lastPrinter, n, n2, n3, this.shrinkToFit);
        if (!printerDialog.didUserCancel()) {
            this.canceled = false;
            ReaderPrefs.fPrintServerPath = printerDialog.getServer();
            ReaderPrefs.fLastPrinter = printerDialog.getPrinter();
            ReaderPrefs.fShrinkToFit = printerDialog.getShrinkToFit();
            ReaderPrefs.fFaxFineMode = printerDialog.getFineMode();
            ReaderPrefs.fLastFaxNumber = printerDialog.getFaxNumber();
            PrintServerDoc printServerDoc = new PrintServerDoc(acroViewContext, this.parent, ReaderPrefs.fPrintServerPath, ReaderPrefs.fLastPrinter, n, n2, n3, ReaderPrefs.fShrinkToFit, printerDialog.getFaxNumber(), ReaderPrefs.fFaxFineMode);
            try {
                Session session = Session.getTheSession();
                if (session.isIE()) {
                    PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
                } else if (session.isNetscape()) {
                    PrivilegeManager.enablePrivilege((String)"UniversalThreadAccess");
                }
                Thread thread = new Thread(printServerDoc);
                thread.setPriority(thread.getPriority() - 1);
                thread.start();
            }
            catch (Exception exception) {
                Log.clog("IronCityPrint: refused " + exception);
            }
        } else {
            this.canceled = true;
        }
    }

    public boolean didUserCancel() {
        return this.canceled;
    }

    class PrinterDialog
    extends BasicDialog {
        private String server;
        private String printer;
        private String printerList;
        private String faxNumber = null;
        private boolean fineMode = false;
        private Choice fPrinterBox;
        private Checkbox fShrink;
        private Frame frame;
        private Panel gridPanel;
        private GridBagLayout grid;
        private GridBagConstraints c;

        public PrinterDialog(Frame frame, String string, String string2, int n, int n2, int n3, boolean bl) {
            super(frame, Util.getDialogString("Print:PrintServer"), true);
            this.frame = frame;
            this.server = string;
            this.printer = string2;
            PrinterList printerList = new PrinterList(frame, string);
            this.wasCanceled = printerList.didUserCancel();
            if (!this.wasCanceled) {
                int n4;
                this.server = printerList.getServer();
                this.printerList = printerList.getList();
                String string3 = new String(this.printerList);
                String string4 = null;
                Vector<String> vector = new Vector<String>();
                while (string3.length() != 0) {
                    String string5 = string3;
                    n4 = string3.indexOf(10);
                    if (n4 < 0) {
                        string5 = string3;
                        string3 = "";
                    } else {
                        string5 = string3.substring(0, n4);
                        string3 = string3.substring(n4 + 1);
                    }
                    if (string5.startsWith("default=")) {
                        string4 = string5.substring(8);
                        continue;
                    }
                    if (string5.startsWith("name=")) {
                        int n5 = string5.indexOf(58);
                        if (n5 > 0) {
                            vector.addElement(string5.substring(5, n5));
                            continue;
                        }
                        vector.addElement(string5.substring(5));
                        continue;
                    }
                    if (string5.length() == 0) continue;
                    vector.addElement(string5);
                }
                int n6 = vector.indexOf(string2);
                if (n6 < 0) {
                    n6 = vector.indexOf(string4);
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                this.removeAll();
                this.setLayout(new BorderLayout(5, 5));
                this.createGridPanel();
                this.fPrinterBox = new Choice();
                n4 = 0;
                while (n4 < vector.size()) {
                    this.fPrinterBox.addItem((String)vector.elementAt(n4));
                    ++n4;
                }
                this.fPrinterBox.select((String)vector.elementAt(n6));
                this.addRow(Util.getDialogString("Print:SelectPrinter"), this.fPrinterBox);
                this.fShrink = new Checkbox(Util.getDialogString("Print:ShrinkToFit"));
                this.fShrink.setState(bl);
                this.addRow(this.fShrink);
                this.add((Component)this.okCancelPanel, "South");
                this.add((Component)this.gridPanel, "Center");
                this.pack();
                this.setResizable(false);
                this.setVisible(true);
            }
        }

        private void addRow(Component component) {
            this.c.gridwidth = 0;
            this.c.gridheight = 1;
            this.c.weightx = 1.0;
            this.c.anchor = 17;
            this.c.fill = 0;
            this.grid.setConstraints(component, this.c);
            this.gridPanel.add(component);
        }

        private void addRow(String string, Component component) {
            this.c.gridwidth = 1;
            this.c.gridheight = 2;
            this.c.weightx = 1.0;
            Label label = new Label(string, 2);
            this.grid.setConstraints(label, this.c);
            this.gridPanel.add(label);
            this.c.gridwidth = 0;
            this.grid.setConstraints(component, this.c);
            this.gridPanel.add(component);
        }

        private void checkForFax(String string, String string2) {
            int n = string2.indexOf("name=" + string);
            if (n > 0) {
                String string3 = string2.substring(n);
                int n2 = string3.indexOf(10);
                if (n2 > 0) {
                    string3 = string3.substring(0, n2);
                }
                if ((n = string3.indexOf(":fax=on")) > 0) {
                    FaxNumberDialog faxNumberDialog = new FaxNumberDialog(this.frame);
                    if (faxNumberDialog.didUserCancel()) {
                        this.wasCanceled = true;
                    } else {
                        this.faxNumber = faxNumberDialog.getFaxNumber();
                        this.fineMode = faxNumberDialog.getFineMode();
                    }
                }
            }
        }

        private void createGridPanel() {
            this.gridPanel = new Panel();
            this.grid = new GridBagLayout();
            this.c = new GridBagConstraints();
            this.gridPanel.setLayout(this.grid);
            this.c.insets = new Insets(1, 4, 1, 4);
            this.c.fill = 1;
        }

        public String getFaxNumber() {
            return this.faxNumber;
        }

        public boolean getFineMode() {
            return this.fineMode;
        }

        public String getPrinter() {
            return this.printer;
        }

        public String getServer() {
            return this.server;
        }

        public boolean getShrinkToFit() {
            return this.fShrink.getState();
        }

        public void ok() {
            this.printer = this.fPrinterBox.getSelectedItem();
            if (!this.wasCanceled) {
                this.checkForFax(this.printer, this.printerList);
                if (this.wasCanceled) {
                    return;
                }
            }
            super.ok();
        }

        class FaxNumberDialog
        extends BasicDialog {
            private TextField fNumber;
            private Checkbox fFineMode;
            private String faxNumber;
            private boolean fineMode;

            public FaxNumberDialog(Frame frame) {
                super(frame, Util.getDialogString("Print:FaxNumber"), true);
                this.setLayout(new BorderLayout(5, 5));
                this.fNumber = new TextField(ReaderPrefs.fLastFaxNumber, 20);
                this.fNumber.setEditable(true);
                this.fNumber.addActionListener(this);
                this.fNumber.addKeyListener(this);
                this.fFineMode = new Checkbox(Util.getDialogString("Print:FineMode"));
                this.fFineMode.setState(ReaderPrefs.fFaxFineMode);
                this.add((Component)this.okCancelPanel, "South");
                this.add((Component)this.fNumber, "North");
                this.add((Component)this.fFineMode, "Center");
                this.pack();
                this.setResizable(false);
                this.setVisible(true);
            }

            public String getFaxNumber() {
                return this.faxNumber;
            }

            public boolean getFineMode() {
                return this.fineMode;
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getComponent() == this.fNumber && keyEvent.getKeyCode() == 10) {
                    this.ok();
                } else {
                    super.keyReleased(keyEvent);
                }
            }

            public void ok() {
                this.faxNumber = this.fNumber.getText();
                this.fineMode = this.fFineMode.getState();
                super.ok();
            }
        }

        class PrinterList
        implements ActionListener {
            private Frame frame;
            private String server;
            private boolean wasCanceled = false;
            private volatile boolean loadComplete;
            private boolean badURL;
            private boolean otherError;
            private String printers;
            private MessageDialog waitDialog;
            private LoadURLdata loader;

            public PrinterList(Frame frame, String string) {
                this.frame = frame;
                this.server = string;
                while (!this.wasCanceled) {
                    this.printers = null;
                    this.otherError = false;
                    this.badURL = false;
                    this.loadComplete = false;
                    this.loader = new LoadURLdata(String.valueOf(this.server) + "/" + IronCityPrint.this.getPrinterScript);
                    this.loader.addActionListener(this);
                    this.waitDialog = new MessageDialog(frame, Util.getDialogString("Print:ServerPrinting"), Util.getDialogString("Print:ListLoad"), PEUtil.getString("General:Cancel"));
                    Thread thread = new Thread(this.loader);
                    thread.setPriority(thread.getPriority() - 1);
                    thread.start();
                    if (!this.loadComplete) {
                        ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
                        if (!this.loadComplete) {
                            this.waitDialog.runDialog();
                        }
                        ((Component)frame).setCursor(Cursor.getDefaultCursor());
                    }
                    this.wasCanceled = this.loadComplete ^ true;
                    this.waitDialog = null;
                    if (this.wasCanceled || this.printers != null) break;
                    MessageDialog messageDialog = new MessageDialog(frame, Util.getDialogString("Print:ServerPrinting"), Util.getDialogString("Print:CantLoadList"));
                    messageDialog.setVisible(true);
                    this.wasCanceled = true;
                }
            }

            public synchronized void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                this.loadComplete = true;
                if (string.equals("OK")) {
                    this.printers = new String(this.loader.getDataBytes());
                } else if (string.equals("IOException")) {
                    this.badURL = true;
                } else {
                    this.otherError = true;
                }
                if (this.waitDialog != null) {
                    this.waitDialog.dispose();
                }
            }

            public boolean didUserCancel() {
                return this.wasCanceled;
            }

            public String getList() {
                return this.printers.replace('\r', '\n');
            }

            public String getServer() {
                return this.server;
            }

            class LoadURLdata
            implements Runnable {
                private String dataURI;
                private byte[] dataBytes = null;
                transient ActionListener actionListener;

                public LoadURLdata(String string) {
                    this.dataURI = string;
                }

                public synchronized void addActionListener(ActionListener actionListener) {
                    this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
                }

                public byte[] getDataBytes() {
                    return this.dataBytes;
                }

                public synchronized void removeActionListener(ActionListener actionListener) {
                    this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
                }

                public void run() {
                    String string;
                    block16: {
                        byte[] byArray = MemUtil.allocByte(512);
                        int n = 0;
                        this.dataBytes = null;
                        InputStream inputStream = null;
                        string = "OK";
                        try {
                            try {
                                int n2;
                                Session session = Session.getTheSession();
                                if (session.isIE()) {
                                    PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
                                } else if (session.isNetscape()) {
                                    PrivilegeManager.enablePrivilege((String)"UniversalConnectWithRedirect");
                                }
                                URL uRL = new URL(this.dataURI);
                                URLConnection uRLConnection = uRL.openConnection();
                                uRLConnection.setUseCaches(false);
                                inputStream = uRLConnection.getInputStream();
                                while ((n2 = inputStream.read(byArray)) != -1) {
                                    byte[] byArray2 = MemUtil.allocByte(n + n2);
                                    if (n != 0) {
                                        System.arraycopy(this.dataBytes, 0, byArray2, 0, n);
                                    }
                                    System.arraycopy(byArray, 0, byArray2, n, n2);
                                    this.dataBytes = byArray2;
                                    n += n2;
                                }
                            }
                            catch (IOException iOException) {
                                string = "IOException";
                            }
                            catch (Exception exception) {
                                string = "Exception";
                            }
                            Object var6_10 = null;
                            if (inputStream == null) break block16;
                        }
                        catch (Throwable throwable) {
                            Object var6_11 = null;
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (this.actionListener != null) {
                                this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
                            }
                            throw throwable;
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (this.actionListener != null) {
                        this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
                    }
                }
            }
        }
    }

    class PrintServerDoc
    implements Runnable {
        private URL fileURL = null;
        private ByteArray fileBytes = null;
        private URL printURL;
        private AcroViewContext context;
        private Frame frame;
        private String urlString;
        private String options;

        public PrintServerDoc(AcroViewContext acroViewContext, Frame frame, String string, String string2, int n, int n2, int n3, boolean bl, String string3, boolean bl2) {
            this.context = acroViewContext;
            this.frame = frame;
            try {
                ByteArraySource byteArraySource = acroViewContext.getVByteArraySource().byteArraySourceValue(null);
                this.fileURL = byteArraySource.getURL();
                this.fileBytes = byteArraySource.getByteArray();
            }
            catch (Exception exception) {}
            this.urlString = String.valueOf(string) + "/" + IronCityPrint.this.printPrinterScript;
            this.options = "?printer=" + URLEncoder.encode(string2.trim());
            if (n != 1 || n2 != n3) {
                this.options = String.valueOf(this.options) + "&startpage=" + Integer.toString(n).trim() + "&endpage=" + Integer.toString(n2).trim();
            }
            if (bl) {
                this.options = String.valueOf(this.options) + "&shrink=on";
            }
            if (string3 != null && string3.length() > 0) {
                this.options = String.valueOf(this.options) + "&faxnum=" + URLEncoder.encode(string3.trim());
                if (bl2) {
                    this.options = String.valueOf(this.options) + "&fine=on";
                }
            }
        }

        public void run() {
            Object object;
            boolean bl;
            String string = Util.getDialogString("Print:Printing");
            boolean bl2 = bl = this.fileURL == null;
            if (!(bl || ((String)(object = this.fileURL.getProtocol())).equals("http") || ((String)object).equals("ftp"))) {
                bl = true;
            }
            if (!bl) {
                this.options = String.valueOf(this.options) + "&source=" + URLEncoder.encode(this.fileURL.toExternalForm());
            }
            object = null;
            try {
                try {
                    InputStream inputStream;
                    Session session = Session.getTheSession();
                    if (session.isIE()) {
                        PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
                    } else if (session.isNetscape()) {
                        PrivilegeManager.enablePrivilege((String)"UniversalConnectWithRedirect");
                    }
                    this.printURL = new URL(String.valueOf(this.urlString) + this.options);
                    object = (HttpURLConnection)this.printURL.openConnection();
                    HttpURLConnection.setFollowRedirects(true);
                    ((URLConnection)object).setUseCaches(false);
                    if (bl) {
                        int n;
                        inputStream = this.fileBytes.getByteStream(0);
                        int n2 = this.fileBytes.getLength();
                        ((URLConnection)object).setRequestProperty("Content-Type", "application/pdf");
                        ((URLConnection)object).setRequestProperty("Content-Length", Integer.toString(n2).trim());
                        ((HttpURLConnection)object).setRequestMethod("POST");
                        ((URLConnection)object).setDoOutput(true);
                        OutputStream outputStream = ((URLConnection)object).getOutputStream();
                        byte[] byArray = MemUtil.allocByte(1024);
                        while ((n = inputStream.read(byArray)) != -1) {
                            outputStream.write(byArray, 0, n);
                        }
                        inputStream.close();
                        outputStream.close();
                    } else {
                        ((HttpURLConnection)object).setRequestMethod("GET");
                        inputStream = ((URLConnection)object).getInputStream();
                        while (inputStream.read() >= 0) {
                        }
                        inputStream.close();
                    }
                    int n = ((HttpURLConnection)object).getResponseCode();
                    if (n != 200) {
                        String string2 = ((HttpURLConnection)object).getResponseMessage();
                        if (string2 == null) {
                            string2 = "";
                        }
                        string = Util.getDialogString("Print:Error", string2);
                    }
                }
                catch (Exception exception) {
                    string = Util.getDialogString("Print:Error", exception.getMessage());
                }
                Object var5_13 = null;
                if (object != null) {
                    ((HttpURLConnection)object).disconnect();
                }
            }
            catch (Throwable throwable) {
                Object var5_14 = null;
                if (object != null) {
                    ((HttpURLConnection)object).disconnect();
                }
                throw throwable;
            }
            MessageDialog messageDialog = new MessageDialog(this.frame, Util.getDialogString("Print:ServerPrinting"), string);
            messageDialog.setVisible(true);
        }
    }
}

