/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.ImageLabel;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.LightWeightPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class ComboBox
extends LightWeightPanel
implements ActionListener,
MouseListener,
KeyListener {
    private TextField fText;
    private PopupMenu fPopup;
    private ImageLabel fButton;
    private int columns = 5;
    private Insets insets;
    private Vector items = new Vector();
    private KeyListener parent;

    public ComboBox() {
        this.insets = new Insets(1, 1, 1, 1);
        this.setLayout(new BorderLayout());
        this.fText = new TextField();
        this.fButton = new ImageLabel(Util.getResourceImage("icons/default/downarrow.gif"));
        this.fPopup = new PopupMenu();
        this.add((Component)this.fText, "Center");
        this.add((Component)this.fButton, "East");
        this.add(this.fPopup);
        this.fText.addActionListener(this);
        this.fText.addKeyListener(this);
        this.fPopup.addActionListener(this);
        this.fButton.addMouseListener(this);
    }

    public ComboBox(KeyListener keyListener) {
        this();
        this.parent = keyListener;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fPopup && actionEvent.getID() == 1001) {
            int n = 0;
            while (n < this.fPopup.getItemCount()) {
                MenuItem menuItem = this.fPopup.getItem(n);
                if (actionEvent.getActionCommand().equals(menuItem.getActionCommand())) {
                    this.fText.setText(menuItem.getLabel());
                }
                ++n;
            }
        }
    }

    public void addItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        this.fPopup.add(menuItem);
        if (string.length() > this.columns) {
            this.columns = string.length();
            this.fText.setColumns(this.columns);
        }
        this.items.addElement(string);
    }

    public void addSeparator() {
        this.fPopup.addSeparator();
    }

    private int getIndex(String string) {
        int n = 0;
        while (n < this.items.size()) {
            String string2 = (String)this.items.elementAt(n);
            if (string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public String getSelectedItem() {
        return this.fText.getText();
    }

    public String getText() {
        return this.fText.getText();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && this.parent != null) {
            this.parent.keyReleased(keyEvent);
        } else if (keyEvent.getKeyCode() == 38) {
            this.selectPrevious();
        } else if (keyEvent.getKeyCode() == 40) {
            this.selectNext();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Dimension dimension = this.fText.getSize();
        this.fPopup.show(this.fText, dimension.width, dimension.height);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(this.getBackground().darker());
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void removeAll() {
        this.items.removeAllElements();
        this.fPopup.removeAll();
    }

    public void requestFocus() {
        this.fText.selectAll();
        this.fText.requestFocus();
    }

    public void select(String string) {
        this.fText.setText(string);
    }

    public void selectAll() {
        this.fText.selectAll();
    }

    private void selectItemAtIndex(int n) {
        this.setText((String)this.items.elementAt(n));
    }

    private void selectNext() {
        int n = this.getIndex(this.getSelectedItem());
        if (n == -1) {
            this.selectItemAtIndex(0);
        } else if (n < this.items.size() - 1) {
            this.selectItemAtIndex(n + 1);
        }
    }

    private void selectPrevious() {
        int n = this.getIndex(this.getSelectedItem());
        if (n == 0 || n == -1) {
            this.selectItemAtIndex(0);
        } else {
            this.selectItemAtIndex(n - 1);
        }
    }

    public void setText(String string) {
        this.fText.setText(string);
    }
}

