/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.file;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.file.ByteArraySourceSpace;
import com.adobe.acrobat.file.URLByteArray;
import com.adobe.acrobat.gui.Authenticator;
import com.adobe.acrobat.util.Util;
import java.net.URL;

class URLByteArraySource
extends ByteArraySource {
    private URLByteArray byteArray;
    URL url;
    private Authenticator authenticator = null;

    public URLByteArraySource(URL uRL) {
        this(uRL, null);
    }

    public URLByteArraySource(URL uRL, Authenticator authenticator) {
        this.url = uRL;
        this.authenticator = authenticator;
    }

    public boolean canDoByteRanges() {
        if (this.authenticator != null) {
            return this.authenticator.canDoByteRanges();
        }
        return false;
    }

    public synchronized void close() throws Exception {
        if (this.byteArray != null) {
            this.byteArray.close();
            this.byteArray = null;
        }
    }

    public String getAuthHeader() {
        if (this.authenticator != null) {
            return this.authenticator.getBASICAuthorization();
        }
        return null;
    }

    public synchronized ByteArray getByteArray() throws Exception {
        if (this.byteArray == null) {
            this.byteArray = new URLByteArray(this, this.url, null);
        }
        return this.byteArray;
    }

    public ByteArraySource getByteArraySourceRelative(String string) throws Exception {
        URL uRL = null;
        uRL = string.charAt(0) == '/' ? new URL(string.substring(1)) : new URL(this.url, string);
        if (this.authenticator == null) {
            return new URLByteArraySource(uRL);
        }
        return new URLByteArraySource(uRL, this.authenticator.getNewAuthenticator(uRL));
    }

    public int getContentLength() {
        if (this.authenticator != null) {
            return this.authenticator.getContentLength();
        }
        return -1;
    }

    public ByteArraySourceSpace getSourceSpace() {
        return ByteArraySourceSpace.getDefaultSourceSpace();
    }

    public String getTitle() {
        return Util.decodeURL(this.url.getFile());
    }

    public URL getURL() {
        return this.url;
    }
}

