/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.bytearray;

import com.adobe.acrobat.bytearray.ByteRange;
import com.adobe.util.Assert;

public class ContiguousByteRange {
    private int start;
    private int end;

    public ContiguousByteRange(int n, int n2) {
        Assert.notFalse(n <= n2);
        this.start = n;
        this.end = Math.min(n2, 0x7FFFFFFE);
    }

    public ContiguousByteRange decapitate(int n) {
        if (n <= this.start) {
            return this;
        }
        if (n > this.end) {
            return null;
        }
        return new ContiguousByteRange(n, this.end);
    }

    private boolean encloses(ContiguousByteRange contiguousByteRange) {
        return this.start <= contiguousByteRange.start && this.end >= contiguousByteRange.end;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContiguousByteRange)) {
            return false;
        }
        ContiguousByteRange contiguousByteRange = (ContiguousByteRange)object;
        return contiguousByteRange.start == this.start && contiguousByteRange.end == this.end;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start + 1;
    }

    public int getStart() {
        return this.start;
    }

    ContiguousByteRange intersection(ContiguousByteRange contiguousByteRange) {
        if (this.intersects(contiguousByteRange)) {
            int n = Math.max(this.start, contiguousByteRange.start);
            int n2 = Math.min(this.end, contiguousByteRange.end);
            if (this.start == n && this.end == n2) {
                return this;
            }
            if (contiguousByteRange.start == n && contiguousByteRange.end == n2) {
                return contiguousByteRange;
            }
            return new ContiguousByteRange(n, n2);
        }
        return null;
    }

    boolean intersects(ContiguousByteRange contiguousByteRange) {
        return this.start <= contiguousByteRange.end && this.end >= contiguousByteRange.start;
    }

    boolean intersectsOrAbuts(ContiguousByteRange contiguousByteRange) {
        if (this.start < contiguousByteRange.start) {
            return this.end >= contiguousByteRange.start - 1;
        }
        return this.start <= contiguousByteRange.end + 1;
    }

    public ByteRange toByteRange() {
        return new ByteRange(this);
    }

    public String toString() {
        if (this.end == 0x7FFFFFFE) {
            return String.valueOf(this.start) + "-";
        }
        return String.valueOf(this.start) + "-" + this.end;
    }

    ContiguousByteRange union(ContiguousByteRange contiguousByteRange) {
        Assert.notFalse(this.intersectsOrAbuts(contiguousByteRange));
        if (this.encloses(contiguousByteRange)) {
            return this;
        }
        if (contiguousByteRange.encloses(this)) {
            return contiguousByteRange;
        }
        return new ContiguousByteRange(Math.min(this.start, contiguousByteRange.start), Math.max(this.end, contiguousByteRange.end));
    }
}

