/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.bytearray;

import com.adobe.acrobat.bytearray.ContiguousByteRange;
import java.io.IOException;
import java.io.InputStream;

public class ByteRangeInputStream
extends InputStream {
    private InputStream stm;
    private ContiguousByteRange br;
    private int ptr;
    private int markedPtr;
    private int currRangeIndex = 0;

    public ByteRangeInputStream(InputStream inputStream, ContiguousByteRange contiguousByteRange) {
        this.br = contiguousByteRange;
        this.stm = inputStream;
        this.ptr = contiguousByteRange.getStart();
    }

    public int available() throws IOException {
        int n = this.stm.available();
        int n2 = this.br.getEnd() + 1 - this.ptr;
        return Math.min(n, n2);
    }

    public void mark(int n) {
        this.stm.mark(n);
        this.markedPtr = this.ptr;
    }

    public boolean markSupported() {
        return this.stm.markSupported();
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n > 0) {
            n = byArray[0] & 0xFF;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        n2 = Math.min(byArray.length - n, n2);
        int n3 = Math.min(this.br.getEnd() - this.ptr + 1, n2);
        if (n3 <= 0) {
            return -1;
        }
        int n4 = this.stm.read(byArray, n, n3);
        if (n4 > 0) {
            this.ptr += n4;
        }
        return n4;
    }

    public void reset() throws IOException {
        this.stm.reset();
        this.ptr = this.markedPtr;
    }

    public long skip(long l) throws IOException {
        long l2;
        if (l <= 0L) {
            return 0L;
        }
        l = Math.min((long)(this.br.getEnd() - this.ptr + 1), l);
        long l3 = 0L;
        while ((l2 = this.stm.skip(l)) != 0L) {
            this.ptr = (int)((long)this.ptr + l2);
            l3 += l2;
            if ((l -= l2) > 0L) continue;
        }
        return l3;
    }
}

