/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.bytearray;

import com.adobe.acrobat.bytearray.ByteCacheMonitor;
import com.adobe.acrobat.bytearray.ByteRange;
import com.adobe.acrobat.bytearray.ContiguousByteRange;
import com.adobe.util.Assert;
import com.adobe.util.MemUtil;
import com.adobe.util.WeakRef;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class ByteCache {
    private Vector monitors;
    private IOException savedException;
    private ByteRange cachedByteRange = ByteRange.getEmptyByteRange();
    private WeakRef[] cachedBytes = null;
    private static int BLOCKSIZE = 32768;
    private int length = -1;
    private byte[] goldenBytes;

    ByteCache(byte[] byArray) {
        this.goldenBytes = byArray;
    }

    public int addBytes(InputStream inputStream, ContiguousByteRange contiguousByteRange) throws IOException {
        int n = contiguousByteRange.getStart();
        int n2 = n / BLOCKSIZE;
        this.insureBlockExists(n2);
        byte[] byArray = (byte[])this.cachedBytes[n2].get();
        int n3 = Math.min(this.blockRemainder(n), contiguousByteRange.getLength());
        int n4 = inputStream.read(byArray, n % BLOCKSIZE, n3);
        if (n4 > 0) {
            this.verifyBytes(n, n4);
            ByteCache byteCache = this;
            synchronized (byteCache) {
                this.cachedByteRange = this.cachedByteRange.union(new ContiguousByteRange(n, n + n4 - 1));
                this.setLength(n + n4);
                this.notifyAll();
                this.notifyByteCacheMonitors();
            }
        }
        return n4;
    }

    private int blockRemainder(int n) {
        return BLOCKSIZE - n % BLOCKSIZE;
    }

    public int getBlocksize() {
        return BLOCKSIZE;
    }

    public ByteRange getCachedByteRange() {
        return this.cachedByteRange;
    }

    public IOException getError() {
        return this.savedException;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public int getUpperBound() {
        if (this.length != -1) {
            return this.length;
        }
        if (this.goldenBytes != null) {
            return this.goldenBytes.length - 1;
        }
        if (this.cachedByteRange.getLength() == 0) {
            return 0;
        }
        return this.cachedByteRange.getEnd();
    }

    private synchronized void insureBlockExists(int n) {
        byte[] byArray;
        this.insureSpaceFor(n);
        if (this.cachedBytes[n] == null) {
            this.cachedBytes[n] = new WeakRef();
        }
        if ((byArray = (byte[])this.cachedBytes[n].get()) == null) {
            this.cachedBytes[n].set(MemUtil.allocByte(BLOCKSIZE));
        }
    }

    private synchronized void insureSpaceFor(int n) {
        ++n;
        if (this.cachedBytes == null) {
            this.cachedBytes = new WeakRef[n];
        } else if (this.cachedBytes.length < n) {
            WeakRef[] weakRefArray = new WeakRef[n];
            System.arraycopy(this.cachedBytes, 0, weakRefArray, 0, this.cachedBytes.length);
            this.cachedBytes = weakRefArray;
        }
    }

    synchronized void lockRange(ContiguousByteRange contiguousByteRange) {
        boolean bl = false;
        if (this.cachedBytes == null) {
            return;
        }
        int n = contiguousByteRange.getStart();
        int n2 = contiguousByteRange.getLength();
        int n3 = n / BLOCKSIZE;
        int n4 = (n + n2 - 1) / BLOCKSIZE;
        if (n4 < 0 || n4 >= this.cachedBytes.length) {
            n4 = this.cachedBytes.length - 1;
        }
        while (n3 <= n4) {
            byte[] byArray;
            if (this.cachedBytes[n3] != null && (byArray = (byte[])this.cachedBytes[n3].get()) == null) {
                int n5 = n3 * BLOCKSIZE;
                ByteCache byteCache = this;
                synchronized (byteCache) {
                    this.cachedByteRange = this.cachedByteRange.subtract(new ContiguousByteRange(n5, n5 + BLOCKSIZE - 1));
                }
                bl = true;
            }
            ++n3;
        }
        if (bl) {
            this.notifyByteCacheMonitors();
        }
    }

    synchronized void notifyByteCacheMonitors() {
        if (this.monitors != null) {
            int n = 0;
            while (n < this.monitors.size()) {
                ByteCacheMonitor byteCacheMonitor = (ByteCacheMonitor)this.monitors.elementAt(n);
                try {
                    byteCacheMonitor.byteCacheChanged();
                }
                catch (Exception exception) {}
                ++n;
            }
        }
    }

    synchronized int read(ContiguousByteRange contiguousByteRange, byte[] byArray, int n) throws InterruptedException {
        int n2 = -1;
        if (contiguousByteRange != null && byArray != null) {
            Assert.notFalse(this.cachedByteRange.contains(contiguousByteRange));
            int n3 = contiguousByteRange.getStart();
            int n4 = byArray.length - n;
            int n5 = n2 = Math.min(contiguousByteRange.getLength(), n4);
            while (n5 > 0) {
                int n6 = n3 / BLOCKSIZE;
                this.insureBlockExists(n6);
                byte[] byArray2 = (byte[])this.cachedBytes[n6].get();
                int n7 = Math.min(this.blockRemainder(n3), n5);
                System.arraycopy(byArray2, n3 % BLOCKSIZE, byArray, n, n7);
                n3 += n7;
                n5 -= n7;
                n += n7;
            }
        }
        return n2;
    }

    public synchronized void registerByteCacheMonitor(ByteCacheMonitor byteCacheMonitor) {
        if (this.monitors == null) {
            this.monitors = new Vector();
        }
        this.monitors.addElement(byteCacheMonitor);
    }

    public void setError(IOException iOException) {
        this.savedException = iOException;
    }

    public synchronized void setLength(int n) {
        if (n > this.length) {
            this.length = n;
            this.notifyByteCacheMonitors();
            this.notifyAll();
        }
    }

    synchronized void unlockRange(ByteRange byteRange) {
        if (this.cachedBytes == null) {
            return;
        }
        int n = this.cachedBytes.length;
        int n2 = 0;
        int n3 = byteRange.numRanges();
        int n4 = 0;
        while (n4 < n3) {
            ContiguousByteRange contiguousByteRange = byteRange.getNthContiguousByteRange(n4);
            int n5 = contiguousByteRange.getStart();
            int n6 = contiguousByteRange.getLength();
            int n7 = n5 / BLOCKSIZE;
            int n8 = (n5 + n6 - 1) / BLOCKSIZE;
            if (n7 >= this.cachedBytes.length) {
                n7 = this.cachedBytes.length - 1;
            }
            if (n8 < 0 || n8 >= this.cachedBytes.length) {
                n8 = this.cachedBytes.length - 1;
            }
            while (n2 < n7) {
                if (this.cachedBytes[n2] != null) {
                    this.cachedBytes[n2].unlockAll();
                }
                ++n2;
            }
            n2 = n8 + 1;
            ++n4;
        }
        while (n2 < n) {
            if (this.cachedBytes[n2] != null) {
                this.cachedBytes[n2].unlockAll();
            }
            ++n2;
        }
    }

    public synchronized void unregisterByteCacheMonitor(ByteCacheMonitor byteCacheMonitor) {
        this.monitors.removeElement(byteCacheMonitor);
    }

    private void verifyBytes(int n, int n2) {
        if (this.goldenBytes != null) {
            int n3 = n / BLOCKSIZE;
            int n4 = (n + n2 - 1) / BLOCKSIZE;
            Assert.notFalse(this.cachedBytes != null && this.cachedBytes.length > n4);
            int n5 = n3 - 1;
            byte[] byArray = null;
            int n6 = n;
            while (n6 < n + n2) {
                int n7 = n6 / BLOCKSIZE;
                if (n5 != n7) {
                    n5 = n7;
                    byArray = (byte[])this.cachedBytes[n7].get();
                    Assert.notFalse(byArray != null);
                }
                Assert.notFalse(this.goldenBytes[n6] == byArray[n6 % BLOCKSIZE]);
                ++n6;
            }
        }
    }
}

