/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.bytearray;

import com.adobe.acrobat.bytearray.ByteArrayReqInvalidExc;
import com.adobe.acrobat.bytearray.ContiguousByteRange;
import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.util.Session;
import com.adobe.acrobat.util.Util;
import com.adobe.util.MemUtil;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import netscape.security.PrivilegeManager;

public abstract class ByteArray {
    private ByteArraySource bas;
    private int cachedLength = -1;
    private IOException exception = null;

    protected ByteArray(ByteArraySource byteArraySource) {
        this.bas = byteArraySource;
    }

    protected int computeLength() throws IOException {
        int n;
        InputStream inputStream = this.getByteStream(0, 0x7FFFFFFE);
        int n2 = 0;
        try {
            int n3;
            byte[] byArray = MemUtil.allocByte(1000);
            do {
                if ((n3 = inputStream.read(byArray, 0, 1000)) == -1) continue;
                n2 += n3;
            } while (n3 != -1);
            n = n2;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return n;
    }

    protected void confirmValid() throws IOException {
    }

    private static int constrainInt(int n, int n2, int n3) {
        if (n < n2) {
            n = n2;
        }
        if (n > n3) {
            n = n3;
        }
        return n;
    }

    protected abstract InputStream createStream(ContiguousByteRange var1) throws IOException;

    private static boolean equalBytes(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            if (byArray[n + n4] != byArray2[n2 + n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public int findBytes(byte[] byArray, int n, int n2, boolean bl, int n3) throws IOException {
        if (n3 == -1) {
            n3 = 1024;
        }
        n3 = Math.max(byArray.length, n3);
        if (bl) {
            return this.findBytesForward(byArray, n == -1 ? 0 : n, n2, n3);
        }
        return this.findBytesBackward(byArray, n == -1 ? this.getLength() : n, n2, n3);
    }

    private int findBytesBackward(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4 = this.getLength();
        int n5 = byArray.length;
        boolean bl = true;
        n2 = n2 == -1 ? n : Math.min(n, n2);
        byte[] byArray2 = MemUtil.allocByte(Math.min(n2, n3) + n5 - 1);
        int n6 = byArray2.length;
        n = ByteArray.constrainInt(n, 0, n4);
        while (n2 > 0) {
            int n7 = Math.min(n2, n3);
            this.getBytes(n - n7, n7, byArray2, n6 - n7 - n5 + 1);
            int n8 = ByteArray.locateBytes(byArray2, n6 - n7 - n5 + 1, n7 + (bl ? 0 : n5 - 1), byArray, false);
            if (n8 != -1) {
                return n - n6 + n5 - 1 + n8;
            }
            System.arraycopy(byArray2, 0, byArray2, n6 - n5 + 1, n5 - 1);
            n2 -= n7;
            n -= n3;
            bl = false;
        }
        return -1;
    }

    private int findBytesForward(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4 = this.getLength();
        int n5 = byArray.length;
        boolean bl = true;
        n2 = n2 == -1 ? n4 - n : Math.min(n4 - n, n2);
        byte[] byArray2 = MemUtil.allocByte(Math.min(n2, n3) + n5 - 1);
        n = ByteArray.constrainInt(n, 0, n4);
        while (n2 > 0) {
            int n6 = Math.min(n2, n3);
            this.getBytes(n, n6, byArray2, n5 - 1);
            int n7 = ByteArray.locateBytes(byArray2, bl ? n5 - 1 : 0, n6 + (bl ? 0 : n5 - 1), byArray, true);
            if (n7 != -1) {
                return n - (n5 - 1) + n7;
            }
            System.arraycopy(byArray2, n6, byArray2, 0, n5 - 1);
            n2 -= n6;
            n += n3;
            bl = false;
        }
        return -1;
    }

    public int findString(String string, int n, int n2, boolean bl, int n3) throws IOException {
        byte[] byArray = Util.rawBytesFromString(string);
        return this.findBytes(byArray, n, n2, bl, n3);
    }

    public ByteArraySource getByteArraySource() {
        return this.bas;
    }

    public InputStream getByteStream(int n) throws IOException {
        return this.getByteStream(new ContiguousByteRange(n, 0x7FFFFFFE));
    }

    public InputStream getByteStream(int n, int n2) throws IOException {
        if (n2 == -1) {
            return this.getByteStream(n);
        }
        if (n2 == 0) {
            return this.getByteStream(null);
        }
        return this.getByteStream(new ContiguousByteRange(n, n + n2 - 1));
    }

    public InputStream getByteStream(ContiguousByteRange contiguousByteRange) throws IOException {
        InputStream inputStream;
        this.throwIfInvalid();
        if (contiguousByteRange == null || contiguousByteRange.getLength() == 0) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalThreadAccess");
            }
            inputStream = this.createStream(contiguousByteRange);
        }
        catch (IOException iOException) {
            this.setInvalid(iOException);
            throw iOException;
        }
        return inputStream;
    }

    public void getBytes(int n, int n2, byte[] byArray, int n3) throws IOException {
        this.getBytes(new ContiguousByteRange(n, n + n2 - 1), byArray, n3);
    }

    public void getBytes(int n, byte[] byArray) throws IOException {
        this.getBytes(n, byArray.length, byArray, 0);
    }

    public void getBytes(ContiguousByteRange contiguousByteRange, byte[] byArray) throws IOException {
        this.getBytes(contiguousByteRange, byArray, 0);
    }

    public void getBytes(ContiguousByteRange contiguousByteRange, byte[] byArray, int n) throws IOException {
        InputStream inputStream = this.getByteStream(contiguousByteRange);
        try {
            int n2 = contiguousByteRange.getLength();
            while (n2 > 0) {
                int n3 = inputStream.read(byArray, n, n2);
                if (n3 == -1) {
                    throw new ByteArrayReqInvalidExc();
                }
                n += n3;
                n2 -= n3;
            }
        }
        finally {
            Object var6_7 = null;
            inputStream.close();
        }
    }

    public int getLength() throws IOException {
        if (this.cachedLength == -1) {
            this.cachedLength = this.computeLength();
        }
        return this.cachedLength;
    }

    protected boolean isValid() {
        return this.exception == null;
    }

    private static int locateBytes(byte[] byArray, int n, int n2, byte[] byArray2, boolean bl) {
        int n3 = byArray.length;
        int n4 = byArray2.length;
        if (bl) {
            int n5 = 0;
            while (n5 < n2 - n4 + 1) {
                if (ByteArray.equalBytes(byArray, n + n5, byArray2, 0, n4)) {
                    return n + n5;
                }
                ++n5;
            }
            return -1;
        }
        int n6 = n2 - 1;
        while (n6 >= 0) {
            if (ByteArray.equalBytes(byArray, n + n6, byArray2, 0, n4)) {
                return n + n6;
            }
            --n6;
        }
        return -1;
    }

    protected void setInvalid(IOException iOException) {
        if (this.exception == null && !(iOException instanceof InterruptedIOException)) {
            this.exception = iOException;
        }
    }

    protected void throwIfInvalid() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

