/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableRenderDemo
extends JPanel {
    private boolean DEBUG = false;

    public TableRenderDemo() {
        super(new GridLayout(1, 0));
        final JTable table = new JTable(new MyTableModel());
        table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        table.setSelectionMode(0);
        ListSelectionModel rowSM = table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    if (selectedRow == 2 || selectedRow == 4) {
                        TableRenderDemo.this.setUpSportColumn(table, table.getColumnModel().getColumn(2), 1);
                    } else {
                        TableRenderDemo.this.setUpSportColumn(table, table.getColumnModel().getColumn(2), 0);
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(table);
        this.initColumnSizes(table);
        this.setUpSportColumn(table, table.getColumnModel().getColumn(2), 0);
        this.add(scrollPane);
    }

    private void initColumnSizes(JTable table) {
        MyTableModel model = (MyTableModel)table.getModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        Object[] longValues = model.longValues;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int i = 0;
        while (i < 5) {
            column = table.getColumnModel().getColumn(i);
            comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width;
            comp = table.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(table, longValues[i], false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
            if (this.DEBUG) {
                System.out.println("Initializing width of column " + i + ". " + "headerWidth = " + headerWidth + "; cellWidth = " + cellWidth);
            }
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
            ++i;
        }
    }

    public void setUpSportColumn(JTable table, TableColumn sportColumn, int InfectionType) {
        if (InfectionType == 0) {
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("Snowboarding");
            comboBox.addItem("Rowing");
            comboBox.addItem("Knitting");
            comboBox.addItem("Speed reading");
            comboBox.addItem("Pool");
            comboBox.addItem("None of the above");
            sportColumn.setCellEditor(new DefaultCellEditor(comboBox));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText("Click for combo box");
            sportColumn.setCellRenderer(renderer);
        } else {
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("Snowboarding");
            comboBox.addItem("Rowing");
            comboBox.addItem("None of the above");
            sportColumn.setCellEditor(new DefaultCellEditor(comboBox));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText("Click for combo box");
            sportColumn.setCellRenderer(renderer);
        }
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("TableRenderDemo");
        frame.setDefaultCloseOperation(3);
        TableRenderDemo newContentPane = new TableRenderDemo();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableRenderDemo.createAndShowGUI();
            }
        });
    }

    class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"First Name", "Last Name", "Sport", "# of Years", "Vegetarian"};
        private Object[][] data = new Object[][]{{"Mary", "Campione", "Snowboarding", new Integer(5), new Boolean(false)}, {"Alison", "Huml", "Rowing", new Integer(3), new Boolean(true)}, {"Kathy", "Walrath", "Knitting", new Integer(2), new Boolean(false)}, {"Sharon", "Zakhour", "Speed reading", new Integer(20), new Boolean(true)}, {"Philip", "Milne", "Pool", new Integer(10), new Boolean(false)}};
        public final Object[] longValues = new Object[]{"Sharon", "Campione", "None of the above", new Integer(20), Boolean.TRUE};

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= 2;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (TableRenderDemo.this.DEBUG) {
                System.out.println("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
            }
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
            if (TableRenderDemo.this.DEBUG) {
                System.out.println("New value of data:");
                this.printDebugData();
            }
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            int i = 0;
            while (i < numRows) {
                System.out.print(" row " + i + ":");
                int j = 0;
                while (j < numCols) {
                    System.out.print(" " + this.data[i][j]);
                    ++j;
                }
                System.out.println();
                ++i;
            }
            System.out.println("--------------------------");
        }
    }
}

