/*
 * Decompiled with CFR 0.152.
 */
package schematron;

import com.topologi.schematron.SchtrnParams;
import java.io.File;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import schematron.SchtrnValidator;

public class Validate {
    static String[] SchematronFiles = new String[]{"IPC1750ARules.sch", "Material.sch", "MaterialGroupRules.sch", "QueryRules.sch", "ExemptionRules.sch"};

    public static String validateFile(File file) {
        String xml = file.getAbsolutePath();
        String result = "";
        SchtrnValidator validator = new SchtrnValidator();
        validator.setEngineStylesheet("Scripts" + File.separator + "schematron-diagnose.xsl");
        SchtrnParams sp = new SchtrnParams();
        validator.setParams(sp);
        validator.setBaseXML(false);
        try {
            int i = 0;
            while (i < SchematronFiles.length) {
                String schema = "Rules" + File.separator + SchematronFiles[i];
                System.out.println("schema-->" + schema);
                System.out.println("File.separator-->" + File.separator);
                System.out.println("SchematronFiles[i]-->" + SchematronFiles[i]);
                result = String.valueOf(result) + validator.validate(xml, schema);
                ++i;
            }
            return result;
        }
        catch (TransformerConfigurationException tce) {
            System.out.println("Configuration error: " + tce.getMessageAndLocation());
            System.out.println("**Config Error**");
        }
        catch (TransformerException te) {
            System.out.println("Transformation error: " + te.getMessageAndLocation());
        }
        catch (Exception e) {
            System.out.println("An error occurred: " + e.getMessage() + "\n" + e);
        }
        return result;
    }
}

