/*
 * Decompiled with CFR 0.152.
 */
package Sign;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPathContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScribaSignature {
    private String signatureAlgo;
    private String canonicalizationMethod;
    private XMLSignature signature;
    private KeyInfo ki;
    private Document doc;
    private String fileName;
    private String outputFile;
    private X509Certificate certificate;
    private PublicKey publicKey;
    private PrivateKey privKey;
    String signedElement;
    String location;
    static boolean etat;

    public ScribaSignature(String inputFile, String alias, char[] kpass, String output, String signedElement, String location) throws Exception {
        this.signedElement = signedElement;
        this.location = location;
        this.fileName = inputFile;
        this.outputFile = output;
        if (this.testSign()) {
            etat = this.checkAliasPass(alias, kpass, ".keystore", "scriba".toCharArray());
            if (etat) {
                try {
                    this.CreateSignAlgo();
                    this.CreateCanonicalizationMethod("EXCLUSIVE");
                    this.CreateSignature();
                    this.CreateContext();
                    this.CreateRef();
                    this.CreateKeyInfo();
                    this.signature.sign((Key)this.privKey);
                    this.CreateOutput(this.outputFile);
                    new File(inputFile).delete();
                }
                catch (Throwable exp) {
                    exp.printStackTrace();
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, String.valueOf(ResourceBundle.getBundle("Sign/Bundle").getString("CAN'T_GENERATE_")) + signedElement + ResourceBundle.getBundle("Sign/Bundle").getString("_SIGNATURE_!"));
        }
    }

    public boolean testSign() throws Exception {
        this.Createdocument();
        NodeList nl = this.doc.getElementsByTagName("ds:Signature");
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getParentNode().getNodeName().equals(this.location)) {
                int choix = JOptionPane.showConfirmDialog(null, String.valueOf(this.signedElement) + ResourceBundle.getBundle("Sign/Bundle").getString("_SIGNATURE_ALREADY_EXIST_DO_YOU_REALY_WANT_TO_RESIGN_!"), ResourceBundle.getBundle("Sign/Bundle").getString("WARNING"), 0);
                if (choix == 0) {
                    int j = 0;
                    while (j < this.doc.getElementsByTagName("ds:Signature").getLength()) {
                        if (!this.doc.getElementsByTagName("ds:Signature").item(0).getParentNode().getNodeName().equals(this.location)) continue;
                        this.doc.getElementsByTagName(this.location).item(0).removeChild(this.doc.getElementsByTagName("ds:Signature").item(0));
                    }
                    return true;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public void CreateRef() throws Exception {
        Transforms transforms = new Transforms(this.doc);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform(this.canonicalizationMethod);
        XPathContainer xpathC = new XPathContainer(this.doc);
        xpathC.setXPathNamespaceContext("xmlns:default", "http://webstds.ipc.org/175x/2.0");
        xpathC.setXPath("ancestor-or-self::default:" + this.signedElement);
        transforms.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xpathC.getElementPlusReturns());
        System.out.println(xpathC.getElementPlusReturns());
        System.out.println(xpathC.getElement());
        this.signature.addDocument("", transforms);
    }

    public void CreateCanonicalizationMethod(String cMethode) throws Exception {
        this.canonicalizationMethod = cMethode.equals("EXCLUSIVE") ? "http://www.w3.org/2001/10/xml-exc-c14n#" : (cMethode.equals("EXCLUSIVE_WITH_COMMENTS") ? "http://www.w3.org/2001/10/xml-exc-c14n#WithComments" : (cMethode.equals("INCLUSIVE") ? "http://www.w3.org/TR/2001/REC-xml-c14n-20010315" : (cMethode.equals("INCLUSIVE_WITH_COMMENTS") ? "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments" : null)));
    }

    void CreateSignAlgo() {
        this.signatureAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String algo = this.publicKey.getAlgorithm().toUpperCase();
        System.out.println("ALGO ::" + algo);
        if (algo.contains("RSA") && algo.contains("SHA1")) {
            this.signatureAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else if (algo.contains("RSA") && algo.contains("SHA256")) {
            this.signatureAlgo = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        } else if (algo.contains("RSA") && algo.contains("SHA384")) {
            this.signatureAlgo = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
        } else if (algo.contains("RSA") && algo.contains("SHA512")) {
            this.signatureAlgo = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
        } else if (algo.startsWith("1.2.840.113549")) {
            this.signatureAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else if (algo.contains("RSA")) {
            this.signatureAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else if (algo.startsWith("1.3.36.3.3.1")) {
            this.signatureAlgo = "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
        } else if (!algo.startsWith("1.2.840.10045")) {
            this.signatureAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
    }

    public void CreateKeyInfo() throws Exception {
        this.signature.addKeyInfo(this.certificate);
        System.err.println(" signature.addKeyInfo(certificate);");
    }

    public void Createdocument() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.doc = dbf.newDocumentBuilder().parse(new FileInputStream(this.fileName));
    }

    public void CreateContext() throws Exception {
        Element sigElement = this.signature.getElement();
        Node node1 = this.doc.getElementsByTagName(this.location).item(0).appendChild(sigElement);
    }

    public void CreateSignature() throws Exception {
        this.signature = new XMLSignature(this.doc, this.fileName, this.signatureAlgo);
    }

    public void CreateOutput(String outputFile) throws Exception {
        FileOutputStream os = outputFile == null ? new FileOutputStream(this.fileName) : new FileOutputStream(outputFile);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(this.doc), new StreamResult(os));
        JOptionPane.showMessageDialog(null, String.valueOf(this.signedElement) + ResourceBundle.getBundle("Sign/Bundle").getString("_SIGNATURE_GENERATED_!"));
    }

    boolean checkAliasPass(String alias, char[] kpass, String ksName, char[] keystorePass) {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            FileInputStream ksfis = new FileInputStream(ksName);
            BufferedInputStream ksbufin = new BufferedInputStream(ksfis);
            ks.load(ksbufin, keystorePass);
            this.publicKey = ks.getCertificate(alias).getPublicKey();
            this.certificate = (X509Certificate)ks.getCertificate(alias);
            this.privKey = (PrivateKey)ks.getKey(alias, kpass);
            return true;
        }
        catch (IOException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE_INFORMATION"));
        }
        catch (NoSuchAlgorithmException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE1_INFORMATION2"));
        }
        catch (KeyStoreException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE2_INFORMATION3"));
            exp.printStackTrace();
            return false;
        }
        catch (CertificateException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_PASSWORD"));
        }
        catch (UnrecoverableKeyException exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE4_INFORMATION5"));
        }
        catch (Exception exp) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("PLEASE_CHECK_YOUR_KEYSTORE5_INFORMATION6"));
        }
        return false;
    }
}

