/*
 * Decompiled with CFR 0.152.
 */
package Sign;

import Sign.ScribaSignature;
import View.ScribaView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ScribaSignFrame
extends JFrame {
    private JButton ButtonCancel;
    private JButton ButtonFindOutput;
    private JButton ButtonSign;
    private JLabel LabelImage;
    private JPanel PanelLabel;
    private JPanel PanelOutput;
    private JPanel PanelRun;
    private JPanel PanelTransforms;
    private JPasswordField PasswordFieldalias;
    private JTextField TFOutputFile;
    private ButtonGroup buttonGrInput;
    private ButtonGroup buttonGrOutput;
    private JLabel jLAlias;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanelGlobal;
    ScribaView frame;
    JFileChooser fileDlg;
    SignFileFilter xmlFilter;
    SignFileFilter KeystoreFilter;
    String signedElement;
    String location;
    String alias;

    public ScribaSignFrame(String signedElement, String location, String alias) {
        this.frame = null;
        this.signedElement = signedElement;
        this.location = location;
        this.alias = alias;
        this.initComponents();
        this.jLAlias.setText(alias);
        this.fileDlg = new JFileChooser(new File(".").getAbsolutePath());
        this.xmlFilter = new SignFileFilter("xml", "XML files *.xml");
        this.KeystoreFilter = new SignFileFilter("keystore", "Keystore file .keystore");
    }

    public ScribaSignFrame(ScribaView frame, String signedElement, String location, String alias) {
        this.frame = frame;
        this.signedElement = signedElement;
        this.location = location;
        this.alias = alias;
        this.initComponents();
        this.jLAlias.setText(alias);
        this.fileDlg = new JFileChooser(new File(".").getAbsolutePath());
        this.xmlFilter = new SignFileFilter("xml", "XML files *.xml");
        this.KeystoreFilter = new SignFileFilter("keystore", "Keystore file .keystore");
    }

    private void initComponents() {
        this.buttonGrInput = new ButtonGroup();
        this.buttonGrOutput = new ButtonGroup();
        this.jPanelGlobal = new JPanel();
        this.PanelLabel = new JPanel();
        this.LabelImage = new JLabel();
        this.PanelTransforms = new JPanel();
        this.jLabel4 = new JLabel();
        this.PasswordFieldalias = new JPasswordField();
        this.jLabel1 = new JLabel();
        this.jLAlias = new JLabel();
        this.PanelOutput = new JPanel();
        this.TFOutputFile = new JTextField();
        this.ButtonFindOutput = new JButton();
        this.jLabel5 = new JLabel();
        this.PanelRun = new JPanel();
        this.ButtonSign = new JButton();
        this.ButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setLocationByPlatform(true);
        this.jPanelGlobal.setMinimumSize(new Dimension(600, 169));
        this.jPanelGlobal.setPreferredSize(new Dimension(600, 250));
        this.jPanelGlobal.setLayout(new BoxLayout(this.jPanelGlobal, 1));
        this.PanelLabel.setMinimumSize(new Dimension(0, 30));
        this.PanelLabel.setPreferredSize(new Dimension(0, 100));
        this.PanelLabel.setLayout(new BorderLayout());
        this.LabelImage.setPreferredSize(new Dimension(10, 30));
        this.PanelLabel.add((Component)this.LabelImage, "Center");
        this.jPanelGlobal.add(this.PanelLabel);
        ResourceBundle bundle = ResourceBundle.getBundle("Sign/Bundle");
        this.PanelTransforms.setBorder(BorderFactory.createTitledBorder(bundle.getString("ScribaSignFrame.PanelTransforms.border.title")));
        this.PanelTransforms.setMinimumSize(new Dimension(384, 100));
        this.PanelTransforms.setOpaque(false);
        this.PanelTransforms.setPreferredSize(new Dimension(384, 100));
        this.PanelTransforms.setLayout(new GridBagLayout());
        this.jLabel4.setText(bundle.getString("ScribaSignFrame.jLabel4.text"));
        this.jLabel4.setMaximumSize(new Dimension(100, 14));
        this.jLabel4.setMinimumSize(new Dimension(100, 14));
        this.jLabel4.setPreferredSize(new Dimension(100, 14));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 35, 4, 0);
        this.PanelTransforms.add((Component)this.jLabel4, gridBagConstraints);
        this.PasswordFieldalias.setMinimumSize(new Dimension(300, 19));
        this.PasswordFieldalias.setPreferredSize(new Dimension(300, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 40);
        this.PanelTransforms.add((Component)this.PasswordFieldalias, gridBagConstraints);
        this.jLabel1.setText(bundle.getString("ScribaSignFrame.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 35, 4, 0);
        this.PanelTransforms.add((Component)this.jLabel1, gridBagConstraints);
        this.jLAlias.setMaximumSize(new Dimension(150, 19));
        this.jLAlias.setMinimumSize(new Dimension(150, 19));
        this.jLAlias.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 3, 4, 0);
        this.PanelTransforms.add((Component)this.jLAlias, gridBagConstraints);
        this.jPanelGlobal.add(this.PanelTransforms);
        this.PanelOutput.setBorder(BorderFactory.createTitledBorder(bundle.getString("ScribaSignFrame.PanelOutput.border.title")));
        this.PanelOutput.setPreferredSize(new Dimension(100, 70));
        this.PanelOutput.setLayout(new GridBagLayout());
        this.TFOutputFile.setMinimumSize(new Dimension(300, 19));
        this.TFOutputFile.setPreferredSize(new Dimension(300, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 15, 0);
        this.PanelOutput.add((Component)this.TFOutputFile, gridBagConstraints);
        this.ButtonFindOutput.setText(bundle.getString("ScribaSignFrame.ButtonFindOutput.text"));
        this.ButtonFindOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScribaSignFrame.this.ButtonFindOutputActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 15, 0);
        this.PanelOutput.add((Component)this.ButtonFindOutput, gridBagConstraints);
        this.jLabel5.setText(bundle.getString("ScribaSignFrame.jLabel5.text"));
        this.jLabel5.setMaximumSize(new Dimension(100, 14));
        this.jLabel5.setMinimumSize(new Dimension(100, 14));
        this.jLabel5.setPreferredSize(new Dimension(100, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 35, 15, 0);
        this.PanelOutput.add((Component)this.jLabel5, gridBagConstraints);
        this.jPanelGlobal.add(this.PanelOutput);
        this.PanelRun.setLayout(new FlowLayout(1, 25, 5));
        this.ButtonSign.setText(bundle.getString("ScribaSignFrame.ButtonSign.text"));
        this.ButtonSign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScribaSignFrame.this.ButtonSignActionPerformed(evt);
            }
        });
        this.PanelRun.add(this.ButtonSign);
        this.ButtonCancel.setText(bundle.getString("ScribaSignFrame.ButtonCancel.text"));
        this.ButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScribaSignFrame.this.ButtonCancelActionPerformed(evt);
            }
        });
        this.PanelRun.add(this.ButtonCancel);
        this.jPanelGlobal.add(this.PanelRun);
        this.getContentPane().add((Component)this.jPanelGlobal, "Center");
        this.pack();
    }

    private void ButtonFindOutputActionPerformed(ActionEvent evt) {
        this.fileDlg.setFileFilter(this.xmlFilter);
        if (this.fileDlg.showSaveDialog(this) == 0) {
            this.TFOutputFile.setText(this.fileDlg.getSelectedFile().getAbsolutePath());
        }
    }

    private void ButtonSignActionPerformed(ActionEvent evt) {
        String error = "";
        String inputFile = this.getInputFile();
        String outputFile = this.getOutputFile();
        if (inputFile == null || inputFile.length() == 0) {
            error = String.valueOf(error) + "Please Provide an Input File Name\n";
        }
        if (outputFile == null || "".equals(outputFile)) {
            error = String.valueOf(error) + "Please Provide an Output File Name\n";
        }
        if (this.PasswordFieldalias.getPassword() == null || this.PasswordFieldalias.getPassword().length == 0) {
            error = String.valueOf(error) + "Please Provide an Alias password\n";
        }
        if (error.length() != 0) {
            JOptionPane.showMessageDialog(this, error);
            return;
        }
        try {
            new ScribaSignature(inputFile, this.alias, this.PasswordFieldalias.getPassword(), outputFile, this.signedElement, this.location);
            if (ScribaSignature.etat) {
                this.dispose();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage(), "Error", 0);
            e.printStackTrace();
            System.out.println("Exception ici ::" + e);
        }
    }

    private void ButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public String getInputFile() {
        return "sign.xml";
    }

    public String getOutputFile() {
        return this.TFOutputFile.getText();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ScribaSignFrame("Request", "Request", "test").setVisible(true);
            }
        });
    }

    public class SignFileFilter
    extends FileFilter {
        String extension;
        String description;

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String s = null;
            String s1 = file.getName();
            int i = s1.lastIndexOf(46);
            s = i > 0 && i < s1.length() - 1 ? s1.substring(i + 1).toLowerCase() : "";
            return s.equals(this.extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public SignFileFilter(String s, String s1) {
            this.extension = s;
            this.description = s1;
        }
    }
}

