/*
 * Decompiled with CFR 0.152.
 */
package RepeateTables;

import RepeateTables.MaterialTableCellRenderer;
import RepeateTables.QueryTable;
import RepeateTables.RohsMapXML;
import RepeateTables.XMLTable;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class RohsQueryTable
extends QueryTable {
    private MaterialTableCellRenderer materialTableCellRenderer;
    int index = 0;
    String[] list;

    public RohsQueryTable(String version) {
        super(version);
        this.initQuery();
        String[] columnUoM = new String[]{"", "false", "true"};
        this.bool = this.CreateComboBoxEditor(columnUoM);
        this.materialTableCellRenderer = new MaterialTableCellRenderer();
        this.table.setDefaultRenderer(this.table.getModel().getColumnClass(0), this.materialTableCellRenderer);
    }

    @Override
    public void addEmptyCell(int col, Vector row) {
        if (this.index < this.list.length) {
            return;
        }
        row.addElement("");
        row.addElement("false");
    }

    @Override
    public void setCellValue(int col, String value) {
        if (this.index >= this.list.length || col >= 3) {
            this.model.setValueAt(value, this.index, col - 2);
        }
    }

    @Override
    public void addRow(int col) {
        if (this.list != null && this.index < this.list.length - 1) {
            ++this.index;
        }
    }

    @Override
    public String getValueOfRow(int row) {
        String value = "";
        if (row == 0) {
            value = String.valueOf(value) + "\n                     <QueryList identity=\"" + this.getVersion() + "\">";
        }
        if (!((String)this.table.getXMLValueAt(row, 0)).trim().equals("")) {
            value = String.valueOf(value) + "\n                         <Query statement=\"" + (String)this.table.getXMLValueAt(row, 0) + "\" response=\"" + this.table.getXMLValueAt(row, 1).toString() + "\"/>";
        }
        if (row == this.table.getRowCount() - 1) {
            value = String.valueOf(value) + "\n                     </QueryList>";
        }
        return value;
    }

    public void initQuery() {
        this.list = (String[])RohsMapXML.queryLists.get(this.version);
        Object[][] data = new String[this.list.length][2];
        int i = 0;
        while (i < this.list.length) {
            data[i][0] = this.list[i];
            data[i][1] = "";
            ++i;
        }
        this.model = new DefaultTableModel(data, new String[]{"Statement", "Response"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                boolean[] blArray = new boolean[2];
                blArray[1] = true;
                this.canEdit = blArray;
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
        this.table = new MyJTable(this.model);
        int[] widthMax = new int[]{1000, 300};
        int[] widthMin = new int[]{550, 100};
        int i2 = 0;
        while (i2 < widthMax.length) {
            this.table.getColumnModel().getColumn(i2).setMaxWidth(widthMax[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < widthMin.length) {
            this.table.getColumnModel().getColumn(i2).setMinWidth(widthMin[i2]);
            ++i2;
        }
        this.table.setMaximumSize(new Dimension(600, 416));
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    public class MyJTable
    extends XMLTable {
        MyJTable(DefaultTableModel model) {
            super(model);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            switch (column) {
                case 1: {
                    return RohsQueryTable.this.bool;
                }
            }
            return super.getCellEditor(row, column);
        }
    }
}

