/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.decode.ASCII85Decode;
import com.sun.pdfview.decode.ASCIIHexDecode;
import com.sun.pdfview.decode.CCITTFaxDecode;
import com.sun.pdfview.decode.DCTDecode;
import com.sun.pdfview.decode.FlateDecode;
import com.sun.pdfview.decode.LZWDecode;
import java.io.IOException;
import java.nio.ByteBuffer;

public class PDFDecoder {
    private PDFDecoder() {
    }

    public static ByteBuffer decodeStream(PDFObject dict, ByteBuffer streamBuf) throws IOException {
        PDFObject encoding = dict.getDictRef("Filter");
        if (encoding != null) {
            PDFObject[] params;
            PDFObject[] ary;
            if (encoding.getType() == 4) {
                ary = new PDFObject[]{encoding};
                params = new PDFObject[]{dict.getDictRef("DecodeParms")};
            } else {
                ary = encoding.getArray();
                PDFObject parmsobj = dict.getDictRef("DecodeParms");
                params = parmsobj != null ? parmsobj.getArray() : new PDFObject[ary.length];
            }
            for (int i = 0; i < ary.length; ++i) {
                String enctype = ary[i].getStringValue();
                if (enctype == null) continue;
                if (enctype.equals("FlateDecode") || enctype.equals("Fl")) {
                    streamBuf = FlateDecode.decode(dict, streamBuf, params[i]);
                    continue;
                }
                if (enctype.equals("LZWDecode") || enctype.equals("LZW")) {
                    streamBuf = LZWDecode.decode(streamBuf, params[i]);
                    continue;
                }
                if (enctype.equals("ASCII85Decode") || enctype.equals("A85")) {
                    streamBuf = ASCII85Decode.decode(streamBuf, params[i]);
                    continue;
                }
                if (enctype.equals("ASCIIHexDecode") || enctype.equals("AHx")) {
                    streamBuf = ASCIIHexDecode.decode(streamBuf, params[i]);
                    continue;
                }
                if (enctype.equals("DCTDecode") || enctype.equals("DCT")) {
                    streamBuf = DCTDecode.decode(dict, streamBuf, params[i]);
                    continue;
                }
                if (enctype.equals("CCITTFaxDecode") || enctype.equals("CCF")) {
                    streamBuf = CCITTFaxDecode.decode(dict, streamBuf, params[i]);
                    continue;
                }
                throw new PDFParseException("Unknown coding method:" + ary[i].getStringValue());
            }
        }
        return streamBuf;
    }
}

