/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.Cache;
import com.sun.pdfview.OutlineNode;
import com.sun.pdfview.PDFDestination;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.PDFParser;
import com.sun.pdfview.PDFXref;
import com.sun.pdfview.action.GoToAction;
import com.sun.pdfview.action.PDFAction;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PDFFile {
    String eol = "\n";
    ByteBuffer buf;
    PDFXref[] objIdx;
    PDFObject root = null;
    PDFObject encrypt = null;
    Cache cache;
    private boolean printable = true;
    private boolean saveable = true;

    public PDFFile(ByteBuffer buf) throws IOException {
        this.buf = buf;
        this.cache = new Cache();
        this.parseFile();
    }

    public boolean isPrintable() {
        return this.printable;
    }

    public boolean isSaveable() {
        return this.saveable;
    }

    public PDFObject getRoot() {
        return this.root;
    }

    public int getNumPages() {
        try {
            return this.root.getDictRef("Pages").getDictRef("Count").getIntValue();
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    public synchronized PDFObject dereference(PDFXref ref) throws IOException {
        int id = ref.getID();
        if (id >= this.objIdx.length || this.objIdx[id] == null) {
            return PDFObject.nullObj;
        }
        PDFObject obj = this.objIdx[id].getObject();
        if (obj != null) {
            return obj;
        }
        int loc = this.objIdx[id].getFilePos();
        if (loc < 0) {
            return PDFObject.nullObj;
        }
        int startPos = this.buf.position();
        this.buf.position(loc);
        obj = this.readObject();
        if (obj == null) {
            obj = PDFObject.nullObj;
        }
        this.objIdx[id].setObject(obj);
        this.buf.position(startPos);
        return obj;
    }

    public static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10 || c == 0 || c == 12;
    }

    public static boolean isDelimiter(int c) {
        return c == 40 || c == 41 || c == 123 || c == 125 || c == 91 || c == 93 || c == 47 || c == 60 || c == 62 || c == 37 || PDFFile.isWhiteSpace(c);
    }

    private PDFObject readObject() throws IOException {
        return this.readObject(false);
    }

    private PDFObject readObject(boolean numscan) throws IOException {
        PDFObject obj = null;
        while (obj == null) {
            byte c;
            while (PDFFile.isWhiteSpace(c = this.buf.get())) {
            }
            if (c == 60) {
                c = this.buf.get();
                if (c == 60) {
                    obj = this.readDictionary();
                    continue;
                }
                this.buf.position(this.buf.position() - 1);
                obj = this.readHexString();
                continue;
            }
            if (c == 40) {
                obj = this.readString();
                continue;
            }
            if (c == 91) {
                obj = this.readArray();
                continue;
            }
            if (c == 47) {
                obj = this.readName();
                continue;
            }
            if (c == 37) {
                this.readLine();
                continue;
            }
            if (c >= 48 && c <= 57 || c == 45 || c == 43 || c == 46) {
                obj = this.readNumber((char)c);
                if (numscan) continue;
                int startPos = this.buf.position();
                PDFObject testnum = this.readObject(true);
                if (testnum != null && testnum.getType() == 2) {
                    PDFObject testR = this.readObject(true);
                    if (testR != null && testR.getType() == 9 && testR.getStringValue().equals("R")) {
                        PDFXref xref = new PDFXref(obj.getIntValue(), testnum.getIntValue());
                        obj = new PDFObject(this, xref);
                        continue;
                    }
                    if (testR != null && testR.getType() == 9 && testR.getStringValue().equals("obj")) {
                        obj = this.readObjectDescription();
                        continue;
                    }
                    this.buf.position(startPos);
                    continue;
                }
                this.buf.position(startPos);
                continue;
            }
            if (c >= 97 && c <= 122 || c >= 65 && c <= 90) {
                obj = this.readKeyword((char)c);
                continue;
            }
            this.buf.position(this.buf.position() - 1);
            break;
        }
        return obj;
    }

    private boolean nextItemIs(String match) throws IOException {
        byte c;
        while (PDFFile.isWhiteSpace(c = this.buf.get())) {
        }
        for (int i = 0; i < match.length(); ++i) {
            if (i > 0) {
                c = this.buf.get();
            }
            if (c == match.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private PDFObject readDictionary() throws IOException {
        PDFObject name;
        HashMap<String, PDFObject> hm = new HashMap<String, PDFObject>();
        while ((name = this.readObject()) != null) {
            if (name.getType() != 4) {
                throw new PDFParseException("First item in dictionary must be a /Name.  (Was " + name + ")");
            }
            PDFObject value = this.readObject();
            if (value == null) continue;
            hm.put(name.getStringValue(), value);
        }
        if (!this.nextItemIs(">>")) {
            throw new PDFParseException("End of dictionary wasn't '>>'");
        }
        return new PDFObject(this, 6, hm);
    }

    private int readHexDigit() throws IOException {
        int a;
        while (PDFFile.isWhiteSpace(a = this.buf.get())) {
        }
        a = a >= 48 && a <= 57 ? (a -= 48) : (a >= 97 && a <= 102 ? (a -= 87) : (a >= 65 && a <= 70 ? (a -= 55) : -1));
        return a;
    }

    private int readHexPair() throws IOException {
        int first = this.readHexDigit();
        if (first < 0) {
            this.buf.position(this.buf.position() - 1);
            return -1;
        }
        int second = this.readHexDigit();
        if (second < 0) {
            this.buf.position(this.buf.position() - 1);
            return first << 4;
        }
        return (first << 4) + second;
    }

    private PDFObject readHexString() throws IOException {
        int val;
        StringBuffer sb = new StringBuffer();
        while ((val = this.readHexPair()) >= 0) {
            sb.append((char)val);
        }
        if (this.buf.get() != 62) {
            throw new PDFParseException("Bad character in Hex String");
        }
        return new PDFObject(this, 3, this.unicode(sb.toString()));
    }

    private String unicode(String input) {
        if (input.length() < 2 || input.length() % 2 != 0) {
            return input;
        }
        int c0 = input.charAt(0) & 0xFF;
        int c1 = input.charAt(1) & 0xFF;
        if (c0 == 254 && c1 == 255 || c0 == 255 && c1 == 254) {
            boolean bigEndian = input.charAt(1) == '\uffff';
            StringBuffer out = new StringBuffer();
            for (int i = 2; i < input.length(); i += 2) {
                if (bigEndian) {
                    out.append((char)(((input.charAt(i + 1) & 0xFF) << 8) + (input.charAt(i) & 0xFF)));
                    continue;
                }
                out.append((char)(((input.charAt(i) & 0xFF) << 8) + (input.charAt(i + 1) & 0xFF)));
            }
            return out.toString();
        }
        return input;
    }

    private PDFObject readString() throws IOException {
        int parencount = 1;
        StringBuffer sb = new StringBuffer();
        while (parencount > 0) {
            int c = this.buf.get() & 0xFF;
            if (c == 40) {
                ++parencount;
            } else if (c == 41) {
                if (--parencount == 0) {
                    c = -1;
                    break;
                }
            } else if (c == 92) {
                c = this.buf.get() & 0xFF;
                if (c == 114) {
                    c = 13;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 98) {
                    c = 8;
                } else if (c == 102) {
                    c = 12;
                }
                if (c == 13) {
                    c = this.buf.get() & 0xFF;
                    if (c != 10) {
                        this.buf.position(this.buf.position() - 1);
                    }
                    c = -1;
                } else if (c == 10) {
                    c = -1;
                } else if (c >= 48 && c <= 57) {
                    int val = 0;
                    for (int count = 0; c >= 48 && c <= 57 && count < 3; ++count) {
                        val = val * 8 + c - 48;
                        c = this.buf.get() & 0xFF;
                    }
                    this.buf.position(this.buf.position() - 1);
                    c = val;
                }
            }
            if (c < 0) continue;
            sb.append((char)c);
        }
        return new PDFObject(this, 3, this.unicode(sb.toString()));
    }

    private String readLine() {
        StringBuffer sb = new StringBuffer();
        while (this.buf.remaining() > 0) {
            char c = (char)this.buf.get();
            if (c == '\r') {
                char n;
                if (this.buf.remaining() <= 0 || (n = (char)this.buf.get(this.buf.position())) != '\n') break;
                this.buf.get();
                break;
            }
            if (c == '\n') break;
            sb.append(c);
        }
        return sb.toString();
    }

    private PDFObject readArray() throws IOException {
        PDFObject obj;
        ArrayList<PDFObject> ary = new ArrayList<PDFObject>();
        while ((obj = this.readObject()) != null) {
            ary.add(obj);
        }
        if (this.buf.get() != 93) {
            throw new PDFParseException("Array should end with ']'");
        }
        PDFObject[] objlist = new PDFObject[ary.size()];
        for (int i = 0; i < objlist.length; ++i) {
            objlist[i] = (PDFObject)ary.get(i);
        }
        return new PDFObject(this, 5, objlist);
    }

    private PDFObject readName() throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while (!PDFFile.isDelimiter(c = this.buf.get())) {
            if (c == 35) {
                int hex = this.readHexPair();
                if (hex >= 0) {
                    c = hex;
                } else {
                    throw new PDFParseException("Bad #hex in /Name");
                }
            }
            sb.append((char)c);
        }
        this.buf.position(this.buf.position() - 1);
        return new PDFObject(this, 4, sb.toString());
    }

    private PDFObject readNumber(char start) throws IOException {
        double value;
        boolean neg = start == '-';
        boolean sawdot = start == '.';
        double dotmult = sawdot ? 0.1 : 1.0;
        double d = value = start >= '0' && start <= '9' ? (double)(start - 48) : 0.0;
        while (true) {
            byte c;
            if ((c = this.buf.get()) == 46) {
                if (sawdot) {
                    throw new PDFParseException("Can't have two '.' in a number");
                }
                sawdot = true;
                dotmult = 0.1;
                continue;
            }
            if (c < 48 || c > 57) break;
            int val = c - 48;
            if (sawdot) {
                value += (double)val * dotmult;
                dotmult *= 0.1;
                continue;
            }
            value = value * 10.0 + (double)val;
        }
        this.buf.position(this.buf.position() - 1);
        if (neg) {
            value = -value;
        }
        return new PDFObject(this, 2, new Double(value));
    }

    private PDFObject readKeyword(char start) throws IOException {
        byte c;
        StringBuffer sb = new StringBuffer(String.valueOf(start));
        while (!PDFFile.isDelimiter(c = this.buf.get())) {
            sb.append((char)c);
        }
        this.buf.position(this.buf.position() - 1);
        return new PDFObject(this, 9, sb.toString());
    }

    private PDFObject readObjectDescription() throws IOException {
        String endcheck;
        long debugpos = this.buf.position();
        PDFObject obj = this.readObject();
        PDFObject endkey = this.readObject();
        if (endkey.getType() != 9) {
            throw new PDFParseException("Expected 'stream' or 'endobj'");
        }
        if (obj.getType() == 6 && endkey.getStringValue().equals("stream")) {
            this.readLine();
            ByteBuffer data = this.readStream(obj);
            if (data == null) {
                data = ByteBuffer.allocate(0);
            }
            obj.setStream(data);
            endkey = this.readObject();
        }
        if ((endcheck = endkey.getStringValue()) == null || !endcheck.equals("endobj")) {
            System.out.println("WARNING: object at " + debugpos + " didn't end with 'endobj'");
        }
        return obj;
    }

    private ByteBuffer readStream(PDFObject dict) throws IOException {
        PDFObject lengthObj = dict.getDictRef("Length");
        int length = -1;
        if (lengthObj != null) {
            length = lengthObj.getIntValue();
        }
        if (length < 0) {
            throw new PDFParseException("Unknown length for stream");
        }
        int start = this.buf.position();
        ByteBuffer streamBuf = this.buf.slice();
        streamBuf.limit(length);
        this.buf.position(this.buf.position() + length);
        int ending = this.buf.position();
        if (!this.nextItemIs("endstream")) {
            System.out.println("read " + length + " chars from " + start + " to " + ending);
            throw new PDFParseException("Stream ended inappropriately");
        }
        return streamBuf;
    }

    private void readTrailer() throws IOException {
        PDFObject permissions;
        this.objIdx = new PDFXref[50];
        while (true) {
            PDFObject prevloc;
            PDFObject obj;
            if (!this.nextItemIs("xref")) {
                throw new PDFParseException("Expected 'xref' at start of table");
            }
            while ((obj = this.readObject()).getType() != 9 || !obj.getStringValue().equals("trailer")) {
                if (obj.getType() != 2) {
                    throw new PDFParseException("Expected number for first xref entry");
                }
                int refstart = obj.getIntValue();
                obj = this.readObject();
                if (obj.getType() != 2) {
                    throw new PDFParseException("Expected number for length of xref table");
                }
                int reflen = obj.getIntValue();
                this.readLine();
                if (refstart + reflen >= this.objIdx.length) {
                    PDFXref[] nobjIdx = new PDFXref[refstart + reflen];
                    System.arraycopy(this.objIdx, 0, nobjIdx, 0, this.objIdx.length);
                    this.objIdx = nobjIdx;
                }
                for (int refID = refstart; refID < refstart + reflen; ++refID) {
                    byte[] refline = new byte[20];
                    this.buf.get(refline);
                    if (this.objIdx[refID] != null) continue;
                    this.objIdx[refID] = refline[17] == 110 ? new PDFXref(refline) : new PDFXref(null);
                }
            }
            PDFObject trailerdict = this.readObject();
            if (trailerdict.getType() != 6) {
                throw new IOException("Expected dictionary after \"trailer\"");
            }
            if (this.root == null) {
                this.root = trailerdict.getDictRef("Root");
            }
            if (this.encrypt == null) {
                this.encrypt = trailerdict.getDictRef("Encrypt");
            }
            if ((prevloc = trailerdict.getDictRef("Prev")) == null) break;
            this.buf.position(prevloc.getIntValue());
        }
        if (this.root == null) {
            throw new PDFParseException("No /Root key found in trailer dictionary");
        }
        if (this.encrypt != null && (permissions = this.encrypt.getDictRef("P")) != null) {
            int perms = permissions.getIntValue();
            if ((perms & 4) == 0) {
                this.printable = false;
            }
            if ((perms & 0x10) == 0) {
                this.saveable = false;
            }
        }
        this.root.dereference();
    }

    private void parseFile() throws IOException {
        String scans;
        int scanPos;
        this.buf.rewind();
        byte[] scan = new byte[32];
        int loc = 0;
        for (scanPos = this.buf.remaining() - scan.length; scanPos >= 0; scanPos -= scan.length - 10) {
            this.buf.position(scanPos);
            this.buf.get(scan);
            scans = new String(scan);
            loc = scans.indexOf("startxref");
            if (loc <= 0) continue;
            if (scanPos + loc + scan.length > this.buf.limit()) break;
            scanPos += loc;
            loc = 0;
            break;
        }
        if (scanPos < 0) {
            throw new IOException("This may not be a PDF File");
        }
        this.buf.position(scanPos);
        this.buf.get(scan);
        scans = new String(scan);
        if (scans.charAt(loc += 10) < ' ') {
            ++loc;
        }
        int numstart = loc;
        while (loc < scans.length() && scans.charAt(loc) >= '0' && scans.charAt(loc) <= '9') {
            ++loc;
        }
        int xrefpos = Integer.parseInt(scans.substring(numstart, loc));
        this.buf.position(xrefpos);
        this.readTrailer();
    }

    public OutlineNode getOutline() throws IOException {
        PDFObject oroot = this.root.getDictRef("Outlines");
        OutlineNode work = null;
        OutlineNode outline = null;
        if (oroot != null) {
            PDFObject scan = oroot.getDictRef("First");
            outline = work = new OutlineNode("<top>");
            while (scan != null) {
                PDFObject kid;
                String title = scan.getDictRef("Title").getStringValue();
                OutlineNode build = new OutlineNode(title);
                work.add(build);
                PDFAction action = null;
                PDFObject actionObj = scan.getDictRef("A");
                if (actionObj != null) {
                    action = PDFAction.getAction(actionObj, this.getRoot());
                } else {
                    PDFObject destObj = scan.getDictRef("Dest");
                    if (destObj != null) {
                        try {
                            PDFDestination dest = PDFDestination.getDestination(destObj, this.getRoot());
                            action = new GoToAction(dest);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                }
                if (action != null) {
                    build.setAction(action);
                }
                if ((kid = scan.getDictRef("First")) != null) {
                    work = build;
                    scan = kid;
                    continue;
                }
                PDFObject next = scan.getDictRef("Next");
                while (next == null) {
                    scan = scan.getDictRef("Parent");
                    next = scan.getDictRef("Next");
                    if ((work = (OutlineNode)work.getParent()) != null) continue;
                }
                scan = next;
            }
        }
        return outline;
    }

    public int getPageNumber(PDFObject page) throws IOException {
        PDFObject parent;
        PDFObject typeObj;
        if (page.getType() == 5) {
            page = page.getAt(0);
        }
        if ((typeObj = page.getDictRef("Type")) == null || !typeObj.getStringValue().equals("Page")) {
            return 0;
        }
        int count = 0;
        while ((parent = page.getDictRef("Parent")) != null) {
            PDFObject[] kids = parent.getDictRef("Kids").getArray();
            for (int i = 0; i < kids.length && !kids[i].equals(page); ++i) {
                PDFObject kcount = kids[i].getDictRef("Count");
                if (kcount != null) {
                    count += kcount.getIntValue();
                    continue;
                }
                ++count;
            }
            page = parent;
        }
        return count;
    }

    public PDFPage getPage(int pagenum) {
        return this.getPage(pagenum, false);
    }

    public PDFPage getPage(int pagenum, boolean wait) {
        Integer key = new Integer(pagenum);
        HashMap resources = null;
        PDFObject pageObj = null;
        boolean needread = false;
        PDFPage page = this.cache.getPage(key);
        PDFParser parser = this.cache.getPageParser(key);
        if (page == null) {
            try {
                resources = new HashMap();
                PDFObject topPagesObj = this.root.getDictRef("Pages");
                pageObj = this.findPage(topPagesObj, 0, pagenum, resources);
                if (pageObj == null) {
                    return null;
                }
                page = this.createPage(pagenum, pageObj);
                byte[] stream = this.getContents(pageObj);
                parser = new PDFParser(page, stream, resources);
                this.cache.addPage(key, page, parser);
            }
            catch (IOException ioe) {
                System.out.println("GetPage inner loop:");
                ioe.printStackTrace();
                return null;
            }
        }
        if (parser != null && !parser.isFinished()) {
            parser.go(wait);
        }
        return page;
    }

    public void stop(int pageNum) {
        PDFParser parser = this.cache.getPageParser(new Integer(pageNum));
        if (parser != null) {
            parser.stop();
        }
    }

    private byte[] getContents(PDFObject pageObj) throws IOException {
        PDFObject contentsObj = pageObj.getDictRef("Contents");
        if (contentsObj == null) {
            throw new IOException("No page contents!");
        }
        PDFObject[] contents = contentsObj.getArray();
        if (contents.length == 1) {
            return contents[0].getStream();
        }
        int len = 0;
        for (int i = 0; i < contents.length; ++i) {
            byte[] data = contents[i].getStream();
            if (data == null) {
                throw new PDFParseException("No stream on content " + i + ": " + contents[i]);
            }
            len += data.length;
        }
        byte[] stream = new byte[len];
        len = 0;
        for (int i = 0; i < contents.length; ++i) {
            byte[] data = contents[i].getStream();
            System.arraycopy(data, 0, stream, len, data.length);
            len += data.length;
        }
        return stream;
    }

    private PDFPage createPage(int pagenum, PDFObject pageObj) throws IOException {
        PDFObject rotateObj;
        PDFObject cropboxObj;
        int rotation = 0;
        Rectangle2D.Float mediabox = null;
        Rectangle2D.Float cropbox = null;
        PDFObject mediaboxObj = this.getInheritedValue(pageObj, "MediaBox");
        if (mediaboxObj != null) {
            mediabox = this.parseRect(mediaboxObj);
        }
        if ((cropboxObj = this.getInheritedValue(pageObj, "CropBox")) != null) {
            cropbox = this.parseRect(cropboxObj);
        }
        if ((rotateObj = this.getInheritedValue(pageObj, "Rotate")) != null) {
            rotation = rotateObj.getIntValue();
        }
        Rectangle2D.Float bbox = cropbox == null ? mediabox : cropbox;
        return new PDFPage(pagenum, bbox, rotation, this.cache);
    }

    private PDFObject findPage(PDFObject pagedict, int start, int getPage, Map resources) throws IOException {
        PDFObject typeObj;
        PDFObject rsrcObj = pagedict.getDictRef("Resources");
        if (rsrcObj != null) {
            resources.putAll(rsrcObj.getDictionary());
        }
        if ((typeObj = pagedict.getDictRef("Type")) != null && typeObj.getStringValue().equals("Page")) {
            return pagedict;
        }
        PDFObject kidsObj = pagedict.getDictRef("Kids");
        if (kidsObj != null) {
            PDFObject[] kids = kidsObj.getArray();
            for (int i = 0; i < kids.length; ++i) {
                int count = 1;
                PDFObject countItem = kids[i].getDictRef("Count");
                if (countItem != null) {
                    count = countItem.getIntValue();
                }
                if (start + count >= getPage) {
                    return this.findPage(kids[i], start, getPage, resources);
                }
                start += count;
            }
        }
        return null;
    }

    private PDFObject getInheritedValue(PDFObject pageObj, String propName) throws IOException {
        PDFObject propObj = pageObj.getDictRef(propName);
        if (propObj != null) {
            return propObj;
        }
        PDFObject parentObj = pageObj.getDictRef("Parent");
        if (parentObj != null) {
            return this.getInheritedValue(parentObj, propName);
        }
        return null;
    }

    public Rectangle2D.Float parseRect(PDFObject obj) throws IOException {
        if (obj.getType() == 5) {
            PDFObject[] bounds = obj.getArray();
            if (bounds.length == 4) {
                return new Rectangle2D.Float(bounds[0].getFloatValue(), bounds[1].getFloatValue(), bounds[2].getFloatValue() - bounds[0].getFloatValue(), bounds[3].getFloatValue() - bounds[1].getFloatValue());
            }
            throw new PDFParseException("Rectangle definition didn't have 4 elements");
        }
        throw new PDFParseException("Rectangle definition not an array");
    }
}

